#include <Mix/MultipleEvent.h>

using namespace Mix;

MultipleEvent::MultipleEvent( BOOL bSignal, Boolean bManualReset, UInt32 count )
{
	m_EventCount = count;

	for( UInt32 i = 0; i < MAXIMUM_WAIT_OBJECTS; i++ )
	{
		m_hEventArray[i] = NULL;
	}

	for( UInt32 i = 0; i < m_EventCount; i++ )
	{
		m_hEventArray[i] = ::CreateEvent( NULL, bManualReset, bSignal, NULL );
	}
}

MultipleEvent::~MultipleEvent( void )
{
	for( UInt32 i = 0; i < m_EventCount; i++ )
	{
		if( m_hEventArray[i] != NULL )
		{
			::CloseHandle( m_hEventArray[i] );
		}
	}
}

//VOiԂɂ
void MultipleEvent::Set( UInt32 index )
{
	if( m_hEventArray[index] != NULL )
	{
		::SetEvent( m_hEventArray[index] );
	}
}

void MultipleEvent::Reset( UInt32 index )
{
	if( m_hEventArray[index] != NULL )
	{
		::ResetEvent( m_hEventArray[index] );
	}
}

void MultipleEvent::SetAll( void )
{
	for( UInt32 i = 0; i < m_EventCount; i++ )
	{
		if( m_hEventArray[i] != NULL )
		{
			::SetEvent( m_hEventArray[i] );
		}
	}
}

void MultipleEvent::ResetAll( void )
{
	for( UInt32 i = 0; i < m_EventCount; i++ )
	{
		if( m_hEventArray[i] != NULL )
		{
			::ResetEvent( m_hEventArray[i] );
		}
	}
}

Boolean MultipleEvent::Wait( UInt32 index, UInt32 timeOut )
{
	DWORD ret = ::WaitForSingleObject( m_hEventArray[index], timeOut );
	return ( ret == WAIT_TIMEOUT )? ( False ) : ( True );
}

UInt32 MultipleEvent::WaitAll( Boolean bAll, UInt32 timeOut )
{
	DWORD ret = ::WaitForMultipleObjects( m_EventCount, m_hEventArray, bAll, timeOut );
	return ( ret == WAIT_TIMEOUT )? ( 0xFFFFFFFF ) : ( ret - WAIT_OBJECT_0 );
}
