#include "Mix/Memory/FixedAllocator.h"

namespace Mix{ namespace Memory{

FixedAllocator::FixedAllocator( UInt32 blockSize, UInt32 unitSize, UInt32 unitNum, UInt32 unitMax ) :
m_BlockSize( SIZE_HEADER + blockSize ),
m_UnitSize( m_BlockSize * unitSize ),
m_UnitCount( 0 ),
m_UnitNum( unitNum ),
m_UnitMax( unitMax ),
m_pAllocateList( NULL ),
m_pFreeTree( NULL )
{
#ifdef _DEBUG
	MIX_ASSERT( ( unitMax == 0 ) || ( unitNum <= unitMax ) );
#endif //_DEBUG

	UInt32 i;

	for( i = 0; i < unitNum; i++ )
	{
		if( CreateNode() == NULL )
		{
			;
		}
	}
}

FixedAllocator::~FixedAllocator( void )
{
	NODE* pNode;
	NODE* pNextNode;

	pNode = m_pAllocateList;
	while( pNode != NULL )
	{
		pNextNode = pNode->pNextL;
		MIX_DELETE_ARRAY( pNode->pBuffer ); 
		MIX_DELETE( pNode );
		pNode = pNextNode;
	}
}

void* FixedAllocator::Allocate( size_t size )
{
	if( ( m_BlockSize - SIZE_HEADER ) < size )
	{
		return NULL;
	}

	NODE* pNode;
	UInt8* pMem;
	UInt8* pMemEnd;
	UInt8* pMemory = NULL;

	//󂢂Ăm[hT
	pNode = m_pAllocateList;
	while( ( pNode != NULL ) && ( pMemory == NULL ) )
	{
		if( m_UnitSize == pNode->sizeUsage  )
		{
			//łɍőɒBĂ̂̓XLbv
			pNode = pNode->pNextL;
			continue;
		}

		pMem = &( pNode->pBuffer[0] );
		pMemEnd = ( pMem + m_UnitSize );
		while( ( pMem < pMemEnd ) && ( pMemory == NULL ) )
		{
			if( *pMem == STATE_UNUSE )
			{
				*pMem = STATE_INUSE;
				pMemory = ( pMem + SIZE_HEADER );
				pNode->sizeUsage += m_BlockSize;
			}
			else
			{
				pMem += m_BlockSize;
			}
		}

		pNode = pNode->pNextL;
	}

	if( pMemory == NULL )
	{
		//VKɃm[hǉ
		pNode = CreateNode();
		if( pNode == NULL )
		{
			return NULL;
		}

		pNode->pBuffer[0] = STATE_INUSE;
		pMemory = &( pNode->pBuffer[SIZE_HEADER] );
		pNode->sizeUsage += m_BlockSize;
	}

	return pMemory;
}

void FixedAllocator::Deallocate( void* ptr )
{
	if( ( m_pFreeTree == NULL ) ||
		( ptr == NULL ) )
	{
		return;
	}

	NODE* pNode;
	UInt8* pMem;
	UInt8* pMemEnd;
	Boolean bFree;

	bFree = False;
	pNode = m_pFreeTree;
	while( ( pNode != NULL ) && ( bFree == False ) )
	{
		if( &( pNode->pBuffer[0] ) > ptr )
		{
			pNode = pNode->pLeftT;
		}
		else if( &( pNode->pBuffer[m_UnitSize - 1] ) < ptr )
		{
			pNode = pNode->pRightT;
		}
		else
		{
			pMem = &( pNode->pBuffer[0] );
			pMemEnd = ( pMem + m_UnitSize );
			while( ( pMem < pMemEnd ) && ( bFree == False ) )
			{
				if( ( pMem + SIZE_HEADER ) == ptr )
				{
					if( ( *pMem ) == STATE_INUSE )
					{
						( *pMem ) = STATE_UNUSE;
#ifdef _DEBUG
						if( pNode->sizeUsage >= m_BlockSize )
						{
							pNode->sizeUsage -= m_BlockSize;
						}
						else
						{
							MIX_ASSERT( pNode->sizeUsage >= m_BlockSize );
							pNode->sizeUsage = 0;
						}
#else //_DEBUG
						pNode->sizeUsage -= m_BlockSize;
#endif //_DEBUG
					}
					else
					{
#ifdef _DEBUG
						//łɉĂ
						MIX_ASSERT( ( *pMem ) == STATE_INUSE );
#endif //_DEBUG
					}

					bFree = True;
				}
				else
				{
					pMem += m_BlockSize;
				}
			}
		}
	}

#ifdef _DEBUG
	//g̃v[ŊǗĂȂnꂽꍇ̓AT[g
	MIX_ASSERT( bFree == True );
#endif //_DEBUG
}

void FixedAllocator::RunGC( void )
{
	if( m_UnitNum >= m_UnitCount )
	{
		return;
	}

	NODE* pNode;
	NODE* pNextNode;
	NODE* pTempNode;
	NODE* pTempList;

	//
	m_UnitCount = 0;

	//svȃm[h폜
	pTempList = NULL;
	pNode = m_pAllocateList;
	while( pNode != NULL )
	{
		pNextNode = pNode->pNextL;

		if( pNode->sizeUsage == 0 )
		{
			MIX_DELETE_ARRAY( pNode->pBuffer );
			MIX_DELETE( pNode );
		}
		else
		{
			pNode->pParentT = NULL;
			pNode->pLeftT = NULL;
			pNode->pRightT = NULL;

			if( pTempList == NULL )
			{
				pNode->pPrevL = NULL;
				pNode->pNextL = NULL;
				pTempList = pNode;
			}
			else
			{
				pNode->pPrevL = NULL;
				pNode->pNextL = pTempList;
				pTempList->pPrevL = pNode;
				pTempList = pNode;
			}

			m_UnitCount++;
		}

		pNode = pNextNode;
	}
	m_pAllocateList = pTempList;

	//c[č\z
	m_pFreeTree = NULL;
	pNode = m_pAllocateList;
	while( pNode != NULL )
	{
		if( m_pFreeTree == NULL )
		{
			pNode->pParentT = NULL;
			pNode->pLeftT = NULL;
			pNode->pRightT = NULL;
			m_pFreeTree = pNode;
		}
		else
		{
			pTempNode = m_pFreeTree;
			while( pTempNode != NULL )
			{
				if( &( pTempNode->pBuffer[0] ) > &( pNode->pBuffer[m_UnitSize - 1] ) )
				{
					if( pTempNode->pLeftT == NULL )
					{
						pNode->pParentT = pTempNode;
						pTempNode->pLeftT = pNode;
						break;
					}
					else
					{
						pTempNode = pTempNode->pLeftT;
					}
				}
				else if( &( pTempNode->pBuffer[m_UnitSize - 1] ) < &( pNode->pBuffer[0] ) )
				{
					if( pTempNode->pRightT == NULL )
					{
						pNode->pParentT = pTempNode;
						pTempNode->pRightT = pNode;
						break;
					}
					else
					{
						pTempNode = pTempNode->pRightT;
					}
				}
				else
				{
					//G[
					MIX_ERROR( L"pc[\zɎs" );
				}
			}
		}

		pNode = pNode->pNextL;
	}
}

FixedAllocator::NODE* FixedAllocator::CreateNode( void )
{
	if( ( m_UnitMax > 0 ) &&
		( m_UnitMax <= m_UnitCount ) )
	{
		return NULL;
	}

	NODE* pNode;
	NODE* pTempNode;

	//m[h쐬
	pNode = new NODE();
	if( pNode == NULL )
	{
		return NULL;
	}

	//m[h̃obt@쐬
	pNode->pBuffer = new UInt8[m_UnitSize];
	if( pNode->pBuffer == NULL )
	{
		MIX_DELETE( pNode );
		return NULL;
	}

	//m[h
	pNode->sizeUsage = 0;
	::ZeroMemory( pNode->pBuffer, m_UnitSize );

	//mۃXgɒǉ
	if( m_pAllocateList == NULL )
	{
		pNode->pPrevL = NULL;
		pNode->pNextL = NULL;
	}
	else
	{
		pNode->pPrevL = NULL;
		pNode->pNextL = m_pAllocateList;
		m_pAllocateList->pPrevL = pNode;
	}
	m_pAllocateList = pNode;

	//Xgɒǉ
	if( m_pFreeTree == NULL )
	{
		pNode->pParentT = NULL;
		pNode->pLeftT = NULL;
		pNode->pRightT = NULL;
		m_pFreeTree = pNode;
	}
	else
	{
		pNode->pLeftT = NULL;
		pNode->pRightT = NULL;

		pTempNode = m_pFreeTree;
		while( pTempNode != NULL )
		{
			if( &( pTempNode->pBuffer[0] ) > &( pNode->pBuffer[m_UnitSize - 1] ) )
			{
				if( pTempNode->pLeftT == NULL )
				{
					pNode->pParentT = pTempNode;
					pTempNode->pLeftT = pNode;
					break;
				}
				else
				{
					pTempNode = pTempNode->pLeftT;
				}
			}
			else if( &( pTempNode->pBuffer[m_UnitSize - 1] ) < &( pNode->pBuffer[0] ) )
			{
				if( pTempNode->pRightT == NULL )
				{
					pNode->pParentT = pTempNode;
					pTempNode->pRightT = pNode;
					break;
				}
				else
				{
					pTempNode = pTempNode->pRightT;
				}
			}
			else
			{
				//G[
				MIX_ERROR( L"pc[̍\zɎs" );

				pNode = m_pAllocateList->pNextL;
				m_pAllocateList = m_pAllocateList->pNextL;
				m_pAllocateList->pPrevL = NULL;

				MIX_DELETE_ARRAY( pNode->pBuffer );
				MIX_DELETE( pNode );

				return NULL;
			}
		}
	}

	//jbg𑝂₷
	m_UnitCount++;

	return pNode;
}

}}
