#include "Mix/Class/Memory/Buffer.h"

namespace Mix{ namespace Memory{

Buffer* Buffer::CreateInstance( void )
{
	return new Buffer();
}

Buffer::Buffer( void ) :
m_pBuffer( NULL ),
m_Size( 0 )
{
}

Buffer::~Buffer( void )
{
	if( m_pBuffer != NULL )
	{
		::free( m_pBuffer );
	}
}

Boolean Buffer::Create( UInt32 size )
{
	if( m_pBuffer != NULL )
	{
		return False;
	}

	m_pBuffer = ::malloc( size );
	if( m_pBuffer == NULL )
	{
		return False;
	}

	m_Size = size;
	::ZeroMemory( m_pBuffer, m_Size );

	return True;
}

const void* Buffer::GetConstPointer( void ) const
{
	return m_pBuffer;
}

void* Buffer::GetPointer( void ) const
{
	return m_pBuffer;
}

UInt32 Buffer::GetSize( void ) const
{
	return m_Size;
}

}}
