#include "Mix/Memory.h"
#include "Mix/Class/Memory/Buffer.h"

using namespace Mix;

void* Memory::Allocate( size_t size )
{
	return ::malloc( size );
}

Boolean Memory::Reallocate( void** ppMemory, size_t size )
{
	void* pTemp = ::realloc( *ppMemory, size );
	if( pTemp == NULL )
	{
		return False;
	}

	( *ppMemory ) = pTemp;

	return True;
}

void Memory::Free( void* pMemory )
{
	if( pMemory != NULL )
	{
		::free( pMemory );
	}
}

void Memory::Copy( void* pDstMemory, const void* pSrcMemory, size_t size )
{
	::CopyMemory( pDstMemory, pSrcMemory, size );
}

void Memory::Fill( void* pMemory, size_t size, UInt8 fill )
{
	::FillMemory( pMemory, size, fill );
}

void Memory::Zero( void* pMemory, size_t size )
{
	::ZeroMemory( pMemory, size );
}

Boolean Memory::CreateBuffer( UInt32 size, const void* pInitialData, Mix::Memory::IBuffer** ppBuffer )
{
	if( ( size == 0 ) ||
		( ppBuffer == NULL ) )
	{
		return False;
	}

	Mix::Memory::Buffer* pBuffer;

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( pBuffer == NULL )
	{
		return False;
	}

	if( pBuffer->Create( size ) == False )
	{
		return False;
	}

	if( pInitialData != NULL )
	{
		::CopyMemory( pBuffer->GetPointer(), pInitialData, size );
	}

	( *ppBuffer ) = pBuffer;

	return True;
}
