#pragma once

namespace Mix{ namespace Input{

	class Keyboard;
	class Mouse;

	class RawInputManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZE;

	private:
		HWND						m_hWnd;

		UInt8*						m_pBuffer;
		UInt32						m_BufferSize;

		Mix::Input::Keyboard*	m_pKeyboard;
		Mix::Input::Mouse*		m_pMouse;

	private:
		Boolean GetDeviceDesc( const TCHAR* pszClass, const TCHAR* pszKeyName, Mix::StringW& name );

	public:
		RawInputManager( void );
		virtual ~RawInputManager( void );

		Boolean Start( HWND hWnd, const Mix::INPUT_CONFIG& cfg, Mix::UserFile* pSysReport );
		void Terminate( void );

		void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );
		void Update( void );

		Boolean GetKeyboard( Mix::Input::IKeyboard** ppKeyboard );
		Boolean GetMouse( Mix::Input::IMouse** ppMouse );
	};

}}
