#include "Mix/Class/Input/RawInputManager.h"
#include "Mix/Class/Input/Keyboard.h"
#include "Mix/Class/Input/Mouse.h"

#include <list>

using namespace Mix::Input;

//KEYBOARD UsagePage 0x01 Usage 0x06
//MOUSE    UsagePage 0x01 Usage 0x02
//GAMEPAD  UsagePage 0x01 Usage 0x05
//JOYSTICK UsagePage 0x01 Usage 0x04

const wchar_t* RawInputManager::FAILED_INITIALIZE = L"Cvbg}l[W̏Ɏs";

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Input::RawInputManager
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

RawInputManager::RawInputManager( void ) :
m_hWnd( NULL ),
m_pBuffer( NULL ),
m_BufferSize( 0 ),
m_pKeyboard( NULL ),
m_pMouse( NULL )
{
}

RawInputManager::~RawInputManager( void )
{
}

Boolean RawInputManager::Start( HWND hWnd, const Mix::INPUT_CONFIG& cfg, Mix::UserFile* pSysReport )
{
	RAWINPUTDEVICE registDeviceArray[2];
	UInt32 registDeviceCount;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_hWnd = hWnd;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	registDeviceCount = 0;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// VXe|[g
	////////////////////////////////////////////////////////////////////////////////////////////////////

	{
		RAWINPUTDEVICELIST* devices = NULL;
		RID_DEVICE_INFO devInfo;
		UInt32 numDevice = 0;
		UInt32 devSize = 0;
		Mix::StringW temp;

		std::list<Mix::StringW> keyboardList;
		std::list<Mix::StringW> mouseList;

		//foCXXg쐬
		::GetRawInputDeviceList( NULL, &numDevice, sizeof( RAWINPUTDEVICELIST ) );
		devices = reinterpret_cast<RAWINPUTDEVICELIST*>( ::HeapAlloc( ::GetProcessHeap(), HEAP_ZERO_MEMORY, sizeof( RAWINPUTDEVICELIST ) * numDevice ) );
		if( devices == NULL )
		{
			return False;
		}
		::GetRawInputDeviceList( devices, &numDevice, sizeof( RAWINPUTDEVICELIST ) );

		//efoCX
		for( UInt32 i = 0; i < numDevice; i++ )
		{
			wchar_t id[MAX_PATH] = L"";
			Mix::StringW productName = L"";

			//foCX擾
			devInfo.cbSize = sizeof( RID_DEVICE_INFO );
			devSize = devInfo.cbSize;
			if( GetRawInputDeviceInfo( devices[i].hDevice, RIDI_DEVICEINFO, &devInfo, &devSize ) <= 0 )
			{
				continue;
			}

			//L[l[擾
			::ZeroMemory( id, sizeof( id ) );
			devSize = sizeof( id );
			if( GetRawInputDeviceInfo( devices[i].hDevice, RIDI_DEVICENAME, id, &devSize ) <= 0 )
			{
				continue;
			}

			switch( devices[i].dwType )
			{
			case RIM_TYPEKEYBOARD:
				//L[{[h( GUID=884b96c3-56ef-11d1-bc8c-00a0c91405dd Class="Keyboard" )
				//devInfo.keyboard.dwType dwSubType
				//0x00000051 ?????????? zfoCX
				//0x00000004 0x00000000 101L[{[h
				if( GetDeviceDesc( L"Keyboard", id, productName ) == True )
				{
					temp.Sprintf( L"%s : t@NVL[̐[%d] L[̑[%d]", productName.GetConstPtr(), devInfo.keyboard.dwNumberOfFunctionKeys, devInfo.keyboard.dwNumberOfKeysTotal );
					keyboardList.push_back( temp );
				}
				break;

			case RIM_TYPEMOUSE:
				//}EX( GUID=378de44c-56ef-11d1-bc8c-00a0c91405dd Class="Mouse" )
				//devInfo.mouse.dwID
				//0x00000002 WVXefoCX( ^[~iT[o[}EXhCo )
				//0x00000020 PS/2݊}EX
				//0x00000100 HIDɏ}EX
				if( GetDeviceDesc( L"Mouse", id, productName ) == True )
				{
					temp.Sprintf( L"%s : {^̑[%d]", productName.GetConstPtr(), devInfo.mouse.dwNumberOfButtons );
					mouseList.push_back( temp );
				}
				break;
			}
		}

		//foCXXg
		::HeapFree( ::GetProcessHeap(), 0, devices );

		pSysReport->WriteLine( L"[L[{[hꗗ]" );
		pSysReport->WriteLine( L"{" );
		if( keyboardList.size() > 0 )
		{
			for( std::list<Mix::StringW>::iterator it = keyboardList.begin(); it != keyboardList.end(); ++it )
			{
				pSysReport->WriteLine( L"    %s", ( *it ).GetConstPtr() );
			}
		}
		else
		{
			pSysReport->WriteLine( L"    ܂" );
		}
		pSysReport->WriteLine( L"}" );
		pSysReport->WriteLine( L"" );

		pSysReport->WriteLine( L"[}EXꗗ]" );
		pSysReport->WriteLine( L"{" );
		if( mouseList.size() > 0 )
		{
			for( std::list<Mix::StringW>::iterator it = mouseList.begin(); it != mouseList.end(); ++it )
			{
				pSysReport->WriteLine( L"    %s", ( *it ).GetConstPtr() );
			}
		}
		else
		{
			pSysReport->WriteLine( L"    ܂" );
		}
		pSysReport->WriteLine( L"}" );
		pSysReport->WriteLine( L"" );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// L[{[h쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( cfg.bUseKeyboard == True )
	{
		registDeviceArray[registDeviceCount].usUsagePage = 0x01;
		registDeviceArray[registDeviceCount].usUsage = 0x06;
		registDeviceArray[registDeviceCount].dwFlags = 0;
		registDeviceArray[registDeviceCount].hwndTarget = hWnd;

		m_pKeyboard = Mix::Input::Keyboard::CreateInstance( m_hWnd );
		if( m_pKeyboard == NULL )
		{
			MIX_LOG_ERROR( L"%s : %s", FAILED_INITIALIZE, Mix::STR_OUTOFMEMORY );
			return False;
		}

		registDeviceCount++;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// }EX쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( cfg.bUseMouse == True )
	{
		registDeviceArray[registDeviceCount].usUsagePage = 0x01;
		registDeviceArray[registDeviceCount].usUsage = 0x02;
		registDeviceArray[registDeviceCount].dwFlags = 0;
		registDeviceArray[registDeviceCount].hwndTarget = hWnd;

		m_pMouse = Mix::Input::Mouse::CreateInstance( m_hWnd );
		if( m_pMouse == NULL )
		{
			MIX_LOG_ERROR( L"%s : %s", FAILED_INITIALIZE, Mix::STR_OUTOFMEMORY );
			return False;
		}

		registDeviceCount++;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// efoCXgpł悤ɂ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( registDeviceCount > 0 )
	{
		if( ::RegisterRawInputDevices( &( registDeviceArray[0] ), registDeviceCount, sizeof( RAWINPUTDEVICE ) ) == FALSE )
		{
			MIX_LOG_ERROR( L"%s : RegisterRawInputDevices %s", FAILED_INITIALIZE, Mix::STR_RETERROR );
			return False;
		}
	}

	return True;
}

void RawInputManager::Terminate( void )
{
	//obt@
	if( m_pBuffer != NULL )
	{
		::free( m_pBuffer );
		m_pBuffer = NULL;
		m_BufferSize = 0;
	}

	//L[{[h
	MIX_RELEASE( m_pKeyboard );

	//}EX
	MIX_RELEASE( m_pMouse );
}

void RawInputManager::Update( void )
{
	if( m_pMouse != NULL )
	{
		m_pMouse->Update();
	}

	if( m_pKeyboard != NULL )
	{
		m_pKeyboard->Update();
	}
}

void RawInputManager::MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	if( msg == WM_INPUT )
	{
		UInt32 dataSize = 0;
		RAWINPUT* pInput = NULL;
		HRAWINPUT hInput = reinterpret_cast<HRAWINPUT>( lParam );

		//̓f[^̃TCY擾
		::GetRawInputData( hInput, RID_INPUT, NULL, &dataSize, sizeof( RAWINPUTHEADER ) );
		if( dataSize == 0 )
		{
			return;
		}

		//̓f[^̃m
		if( m_BufferSize == 0 )
		{
			m_pBuffer = static_cast<UInt8*>( ::malloc( dataSize ) );
			if( m_pBuffer != NULL )
			{
				m_BufferSize = dataSize;
			}
		}
		else if( dataSize > m_BufferSize )
		{
			UInt8* temp = static_cast<UInt8*>( ::realloc( m_pBuffer, dataSize ) );
			if( temp != NULL )
			{
				m_pBuffer = temp;
				m_BufferSize = dataSize;
			}
			else
			{
				::free( m_pBuffer );
				m_pBuffer = NULL;
				m_BufferSize = 0;
			}
		}
		if( m_pBuffer == NULL )
		{
			return;
		}

		//̓f[^擾
		if( ::GetRawInputData( hInput, RID_INPUT, m_pBuffer, &m_BufferSize, sizeof( RAWINPUTHEADER ) ) != dataSize )
		{
			return;
		}
		pInput = reinterpret_cast<RAWINPUT*>( &( m_pBuffer[0] ) );

		//̓f[^
		if( ( m_pMouse != NULL ) &&
			( pInput->header.dwType == RIM_TYPEMOUSE ) )
		{
			m_pMouse->ProcessInput( pInput );
		}
		else if(	( m_pKeyboard != NULL ) &&
					( pInput->header.dwType == RIM_TYPEKEYBOARD ) )
		{
			m_pKeyboard->ProcessInput( pInput );
		}
	}
	else
	{
		if( m_pMouse != NULL )
		{
			m_pMouse->MessageProc( msg, wParam, lParam );
		}

		if(	m_pKeyboard != NULL )
		{
			m_pKeyboard->MessageProc( msg, wParam, lParam );
		}
	}
}

Boolean RawInputManager::GetKeyboard( Mix::Input::IKeyboard** ppKeyboard )
{
	if( m_pKeyboard == NULL )
	{
		return False;
	}

	( *ppKeyboard ) = m_pKeyboard;
	( *ppKeyboard )->AddRef();

	return True;
}

Boolean RawInputManager::GetMouse( Mix::Input::IMouse** ppMouse )
{
	if( m_pMouse == NULL )
	{
		return False;
	}

	( *ppMouse ) = m_pMouse;
	( *ppMouse )->AddRef();

	return True;
}

Boolean RawInputManager::GetDeviceDesc( const TCHAR* pclassName, const TCHAR* pKeyName, Mix::StringW& name )
{
	Int32 i = 0;
	UInt32 step = 0;
	Boolean bEnd = False;
	HKEY hKey = NULL;
	DWORD dwSize = 0;
	Boolean bRet = False;
	const wchar_t* pk = &( pKeyName[4] );
	wchar_t pathArray[3][MAX_PATH];
	wchar_t regKey[MAX_PATH];
	wchar_t className[MAX_PATH];
	wchar_t temp[2014];

	::ZeroMemory( pathArray, sizeof( pathArray ) );
	::ZeroMemory( className, sizeof( className ) );

	//NXATuNXAvgR擾
	while( step < 3 )
	{
		i = 0;
		while( pk[0] != L'#' )
		{
			pathArray[step][i++] = *pk++;
		}
		step++;
		pk++;
	}

	//WXgL[쐬
	::wsprintf( regKey, L"SYSTEM\\CurrentControlSet\\Enum\\%s\\%s\\%s", pathArray[0], pathArray[1], pathArray[2] );

	//WXgJ
	if( ::RegOpenKeyEx( HKEY_LOCAL_MACHINE, regKey, 0, KEY_READ, &hKey ) == ERROR_SUCCESS )
	{
		//NX擾r
		dwSize = ( sizeof( className ) >> 1 );
		if( ( ::RegQueryValueEx( hKey, L"Class", NULL, NULL, reinterpret_cast<LPBYTE>( &( className[0] ) ), &dwSize ) == ERROR_SUCCESS ) &&
			( ::wcscmp( pclassName, className ) == 0 ) )
		{
			//foCX擾
			dwSize = sizeof( temp );
			if( ::RegQueryValueEx( hKey, L"DeviceDesc", NULL, NULL, reinterpret_cast<LPBYTE>( &( temp[0] ) ), &dwSize ) == ERROR_SUCCESS )
			{
				//%sprintfɂ܂ƂɂȂ̂Ŕr
				//ł@
				for( i = 0; temp[i] != L'\0'; i++ )
				{
					if( ( temp[i] == L'@' ) ||
						( temp[i] == L'%' ) )
					{
						temp[i] = L'_';
					}
				}

				//Windows Vista 7 Ɨ]Ȃ̂tĂ̔r
				//Ō̃Z~R̂ƂfoCX̂悤ł
				for( i = ( ::wcslen( temp ) - 1 ); i >= 0; i-- )
				{
					if( temp[i] == L';' )
					{
						break;
					}
				}

				name = &( temp[i + 1] );

				bRet = True;
			}
		}

		::RegCloseKey( hKey );
	}

	return bRet;
}

