#pragma once

#include "Mix/Class/Input/RawInputDevice.h"
#include "Mix/Input/IMouse.h"
#include "Mix/CriticalSection.h"
#include "Mix/Semaphore.h"

namespace Mix{ namespace Input{

	class Mouse : public Mix::Input::RawInputDevice, public Mix::Input::IMouse
	{
	public:
		static Mouse* CreateInstance( HWND hWnd );

	private:
		enum PRIVATE_VALUE
		{
			MAX_BUTTON = 5, //{^
		};

	private:
		HWND		m_hWnd;

		UInt8		m_ButtonStateBitmap;
		UInt32		m_ButtonStateTable[Mouse::MAX_BUTTON][2];
		UInt32		m_ButtonStateList[Mouse::MAX_BUTTON];

		UInt32		m_NextWheelDelta;
		UInt32		m_WheelDelta;
		Mix::Point	m_NextVelocity;
		Mix::Point	m_Velocity;
		Mix::Point	m_RelativePos;
		Mix::Point	m_Pos;
		Mix::Point	m_ScreenPos;

		Boolean		m_bInside;

		Boolean		m_bProcEnabled;

	private:
		Mouse( HWND hWnd );
		virtual ~Mouse( void );

		void ProcPos_VA( const RAWMOUSE* pm );
		void ProcPos_DR( const RAWMOUSE* pm );
		void ProcBtn( const RAWMOUSE* pm );

		void ResetPos( void );

	public:
		virtual void ProcessInput( const RAWINPUT* pInput );
		virtual void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

	public:
		virtual void Update( void );

	public:
		virtual UInt32 GetButtonState( UInt32 button );
		virtual Int32 GetWheelDelta( void );
		virtual void SetPos( Int32 x, Int32 y );
		virtual void SetPos( const Mix::Point& pos );
		virtual const Mix::Point& GetVelocity( void ) const;
		virtual const Mix::Point& GetPos( void ) const;
		virtual const Mix::Point& GetScreenPos( void ) const;
	};

}}
