#pragma once

#include "Mix/Input/IManager.h"
#include "Mix/Class/Input/RawInputManager.h"
#include "Mix/Class/Input/GamepadManager.h"

namespace Mix{ namespace Input{

	class Manager : public Mix::Input::IManager
	{
	public:
		static Manager* CreateInstance( void );

	private:
		Mix::Input::RawInputManager m_RawInputMgr;
		Mix::Input::GamepadManager m_GamepadMgr;

	private:
		Manager( void );
		virtual ~Manager( void );

	public:
		Boolean Initialize( HWND hWnd, const Mix::INPUT_CONFIG& cfg, Mix::UserFile* pSysReport );
		void Dispose( void );

		void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );
		void Update( void );

	public:
		virtual Boolean GetKeyboard( Mix::Input::IKeyboard** ppKeyboard );
		virtual Boolean GetMouse( Mix::Input::IMouse** ppMouse );
		virtual Boolean GetGamepad( UInt32 port, Mix::Input::IGamepad** ppGamepad );
		virtual Boolean FindGamepad( Mix::Input::GAMEPAD_API api, Mix::Input::IGamepad** ppGamepad );
	};

}}
