#include "Mix/Class/Input/Manager.h"

namespace Mix{ namespace Input{

Manager* Manager::CreateInstance( void )
{
	return new Manager();
}

Manager::Manager( void )
{
}

Manager::~Manager( void )
{
}

Boolean Manager::Initialize( HWND hWnd, const Mix::INPUT_CONFIG& cfg, Mix::UserFile* pSysReport )
{
	//^Cg
	pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
	pSysReport->WriteLine( L"//                                                                                            //" );
	pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
	pSysReport->WriteLine( L"" );

	if( ( cfg.bUseKeyboard == True ) ||
		( cfg.bUseMouse == True ) )
	{
		if( m_RawInputMgr.Start( hWnd, cfg, pSysReport ) == False )
		{
			return False;
		}
	}

	if( cfg.bUseGamepad == True )
	{
		if( m_GamepadMgr.Start( hWnd, pSysReport ) == False )
		{
			return False;
		}
	}

	return True;
}

void Manager::Dispose( void )
{
	m_GamepadMgr.Terminate();
	m_RawInputMgr.Terminate();
}

void Manager::MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	m_RawInputMgr.MessageProc( msg, wParam, lParam );
}

void Manager::Update( void )
{
	m_RawInputMgr.Update();
	m_GamepadMgr.Update();
}

Boolean Manager::GetKeyboard( Mix::Input::IKeyboard** ppKeyboard )
{
	return m_RawInputMgr.GetKeyboard( ppKeyboard );
}

Boolean Manager::GetMouse( Mix::Input::IMouse** ppMouse )
{
	return m_RawInputMgr.GetMouse( ppMouse );
}

Boolean Manager::GetGamepad( UInt32 port, Mix::Input::IGamepad** ppGamepad )
{
	return m_GamepadMgr.Get( port, ppGamepad );
}

Boolean Manager::FindGamepad( Mix::Input::GAMEPAD_API api, Mix::Input::IGamepad** ppGamepad )
{
	return m_GamepadMgr.Find( api, ppGamepad );
}

}}
