#pragma once

#include "Mix/Class/Input/RawInputDevice.h"
#include "Mix/Input/IKeyboard.h"
#include "Mix/Semaphore.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace Input{

	class Keyboard : public Mix::Input::RawInputDevice, public Mix::Input::IKeyboard
	{
	public:
		static Keyboard* CreateInstance( HWND hWnd );

	private:
		HWND	m_hWnd;				//EBhEnh
		Boolean	m_bEnableUpdate;	//XVLȏꍇ True

		UInt8	m_VKConvTable[256];	//zL[ϊe[u

		UInt32 m_KeyStateArray[Mix::Input::KEY_MAX];	//L[Ԕz

		UInt8	m_KeyInfoList[Mix::Input::KEY_MAX];	//L[񃊃Xg( 0x00:Abv 0xFF:_E )

		UInt8	m_UpdateKeyList[Mix::Input::KEY_MAX];	//XVꂽL[̃Xg
		UInt8	m_UpdateKeyCount;							//XVꂽL[̐

		UInt16	m_LastUpdateKeyList[Mix::Input::KEY_MAX];	//OXVL[̃Xg
		UInt8	m_LastUpdateKeyCount;							//OXVL[̐

	private:
		Keyboard( HWND hWnd );
		virtual ~Keyboard( void );

	public:
		virtual void ProcessInput( const RAWINPUT* pInput );
		virtual void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

	public:
		virtual void Update( void );

	public:
		virtual UInt32 GetKeyState( Mix::Input::KEY key ) const;
	};

}}
