#pragma once

#include <vector>

namespace Mix{ namespace Input{

	class Gamepad;

	class GamepadManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZE;

		static DIOBJECTDATAFORMAT OBJ_DATA_FORMAT[61];
		static const DIDATAFORMAT DATA_FORMAT;

	private:
		//foCX񋓍\
		struct ENUMDEVICE
		{
			GamepadManager* pMgr;
			Mix::UserFile* pSysReport;
			UInt32 port;
		};

		//񋓍\
		struct ENUMAXIS
		{
			LPDIRECTINPUTDEVICE8 pDevice;
			Boolean bSuccess;
		};

	private:
		HWND m_hWnd;
		LPDIRECTINPUT8 m_pDI;
		Mix::Input::Gamepad* m_pGamepadList[Mix::Input::GAMEPAD_PORT_MAX];

	public:
		GamepadManager( void );
		virtual ~GamepadManager( void );

	private:
		static Boolean CheckXInputDevice( const GUID& productGuid );
		static BOOL CALLBACK DI_EnumDeviceCallback( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef );
		static BOOL CALLBACK DI_EnumAxisCallback( LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef );

	public:
		Boolean Start( HWND hWnd, Mix::UserFile* pSysReport );
		void Terminate( void );
		void Update( void );

		Boolean Get( UInt32 port, Mix::Input::IGamepad** ppGamepad );
		Boolean Find( Mix::Input::GAMEPAD_API api, Mix::Input::IGamepad** ppGamepad );
	};

}}
