#pragma once

#include "Mix/Input/IGamepad.h"

namespace Mix{ namespace Input{

	class Gamepad : public Mix::Input::IGamepad
	{
	public:
		struct STICK_CAP
		{
			Int16 deadZone;
			Float32 minusNorm;
			Float32 plusNorm;
		};

	protected:
		Gamepad::STICK_CAP m_StickCap[Mix::Input::GAMEPAD_FINGER_MAX];

	protected:
		Gamepad( void );
		virtual ~Gamepad( void );

	public:
		virtual void Update( void ) = 0;
		virtual void Dispose( void ) = 0;

	public:
		virtual void SetStickDeadZone( UInt32 index, Int16 deadZone );
		virtual Int16 SetStickDeadZone( UInt32 index ) const;

	protected:
		static const Mix::Vector2 DUMMY_STICK_STATE;
	};

	class NullGamepad : public Mix::Input::Gamepad
	{
	public:
		static NullGamepad* CreateInstance( void );

	protected:
		NullGamepad( void );
		virtual ~NullGamepad( void );

	public:
		virtual void Update( void );
		virtual void Dispose( void );

	public:
		virtual UInt32 GetButtonState( UInt32 index ) const;
		virtual Float32 GetTriggerState( UInt32 index ) const;
		virtual const Mix::Vector2& GetStickState( UInt32 index ) const;
		virtual Boolean IsAvailable( void ) const;
		virtual Mix::Input::GAMEPAD_API GetAPI( void ) const;
		virtual void SetButtonAssignment( UInt32 targetIndex, UInt32 sourceIndex );
		virtual UInt32 GetButtonAssignment( UInt32 targetIndex ) const;
		virtual void SetTriggerAssignment( UInt32 targetIndex, UInt32 sourceIndex );
		virtual UInt32 GetTriggerAssignment( UInt32 targetIndex ) const;
		virtual void SetTriggerThreshold( UInt32 index, UInt8 threshold );
		virtual UInt8 GetTriggerThreshold( UInt32 index ) const;
	};
}}
