#include "Mix/Class/Input/Gamepad.h"

namespace Mix{ namespace Input{

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Gamepad
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

const Mix::Vector2 Gamepad::DUMMY_STICK_STATE = Mix::Vector2( 0.0f, 0.0f );

Gamepad::Gamepad( void )
{
	SetStickDeadZone( Mix::Input::GAMEPAD_LEFT, XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE );
	SetStickDeadZone( Mix::Input::GAMEPAD_RIGHT, XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE );
}

Gamepad::~Gamepad( void )
{
}

void Gamepad::SetStickDeadZone( UInt32 index, Int16 deadZone )
{
	if( index < Mix::Input::GAMEPAD_FINGER_MAX )
	{
		Gamepad::STICK_CAP* pCap = &( m_StickCap[index] );
		
		deadZone = MIX_CLAMP( deadZone, 0, Mix::Input::GAMEPAD_STICK_RESOLUTION );

		pCap->deadZone = XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE;
		pCap->minusNorm = static_cast<Float32>( 32768 - deadZone );
		pCap->plusNorm = static_cast<Float32>( 32767 - deadZone );
	}
}

Int16 Gamepad::SetStickDeadZone( UInt32 index ) const
{
	if( index >= Mix::Input::GAMEPAD_FINGER_MAX )
	{
		return Mix::Input::GAMEPAD_STICK_RESOLUTION;
	}

	return m_StickCap[index].deadZone;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NullGamepad
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

NullGamepad* NullGamepad::CreateInstance( void )
{
	return new NullGamepad();
}

NullGamepad::NullGamepad( void )
{
}

NullGamepad::~NullGamepad( void )
{
}

void NullGamepad::Update( void )
{
}

void NullGamepad::Dispose( void )
{
}

UInt32 NullGamepad::GetButtonState( UInt32 index ) const
{
	return 0;
}

Float32 NullGamepad::GetTriggerState( UInt32 index ) const
{
	return 0.0f;
}

const Mix::Vector2& NullGamepad::GetStickState( UInt32 index ) const
{
	return Gamepad::DUMMY_STICK_STATE;
}

Boolean NullGamepad::IsAvailable( void ) const
{
	return False;
}

Mix::Input::GAMEPAD_API NullGamepad::GetAPI( void ) const
{
	return Mix::Input::GAMEPAD_UNKNOWN;
}

void NullGamepad::SetButtonAssignment( UInt32 targetIndex, UInt32 sourceIndex )
{
}

UInt32 NullGamepad::GetButtonAssignment( UInt32 targetIndex ) const
{
	return 0xFFFFFFFF;
}

void NullGamepad::SetTriggerAssignment( UInt32 targetIndex, UInt32 sourceIndex )
{
}

UInt32 NullGamepad::GetTriggerAssignment( UInt32 targetIndex ) const
{
	return 0xFFFFFFFF;
}

void NullGamepad::SetTriggerThreshold( UInt32 index, UInt8 threshold )
{
}

UInt8 NullGamepad::GetTriggerThreshold( UInt32 index ) const
{
	return Mix::Input::GAMEPAD_TRIGGER_RESOLUTION;
}

}}
