#pragma once

#include "Mix/Reference.h"
#include "Mix/Class/Container.h"
#include "Mix/Graphics/Utility/IFont.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

	class TextPrinter : public Mix::Reference
	{
	public:
		struct QUAD_GROUP
		{
			Mix::Graphics::ITexture* pTexture;

			UInt32 quadStart;
			UInt32 quadCount;
		};

		struct QUAD
		{
			Mix::Vector2 points[4];
			Mix::Vector2 texCoords[4];
		};

	private:
		enum VALUE
		{
			TEX_MARGIN = 2,
			TEX_MARGIN2 = ( TEX_MARGIN + TEX_MARGIN ),
		};

		struct PAGE
		{
			Mix::Graphics::ITexture* pTexture;

			UInt32 sectStart;
			UInt32 sectCount;
		};

		struct SECTION
		{
			Mix::Graphics::Utility::IFont* pFont;

			UInt32 charStart;
			UInt32 charCount;
		};

		struct CHARACTER
		{
			Mix::Point texPos;
			Mix::Graphics::Utility::IFont::GLYPH fontGlyph;
		};

	public:
		static TextPrinter* CreateInstance( Mix::Graphics::IDevice* pDevice, const wchar_t* pName );

	private:
		Mix::StringW m_Name;

		Mix::Graphics::IDevice* m_pDevice;

		Mix::Container<TextPrinter::PAGE> m_PageList;
		Mix::Container<TextPrinter::SECTION> m_SectList;
		Mix::Container<TextPrinter::CHARACTER> m_CharList;

		Mix::Container<TextPrinter::QUAD_GROUP> m_QuadGroupList;
		Mix::Container<TextPrinter::QUAD> m_QuadList;

		Int32 m_TexSize;
		Float32 m_TexSizeInv;

		Mix::Point m_TexPos;
		Int32 m_TexLine;

		UInt32 m_PageCount;

	private:
		TextPrinter( Mix::Graphics::IDevice* pDevice, const wchar_t* pName );
		virtual ~TextPrinter( void );

		TextPrinter::PAGE* AddPage( Mix::Graphics::Utility::IFont* pFont );
		TextPrinter::PAGE* GetCurrentPage( void );

		TextPrinter::SECTION* AddSection( Mix::Graphics::Utility::IFont* pFont );

		Mix::Graphics::ITexture* CreateTexture( void );

	public:
		Boolean Initialize( Int32 texSize, UInt32 defTexCount );

		Boolean Append( Mix::Graphics::Utility::IFont* pFont, const Mix::Vector2& pos, const wchar_t* pText );
		Boolean AppendString( Mix::Graphics::Utility::IFont* pFont, const wchar_t* pStr, UInt32 count );

		const Mix::Container<TextPrinter::QUAD_GROUP>& GetQuadGroups( void ) const;
		const Mix::Container<TextPrinter::QUAD>& GetQuads( void ) const;

		void Execute( void );

		UInt32 GetTextureCount( void ) const;
		Mix::Graphics::ITexture* GetTexturePtr( UInt32 index ) const;

	private:
		static const wchar_t* FAILED_INIT;
		static const wchar_t* FAILED_PROC;
	};

}}}}
