#pragma once

#include "Mix/Graphics/Utility/IText.h"
#include "Mix/Graphics/Utility/IFont.h"
#include "Mix/Class/Container.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

	class Text : public Mix::Graphics::Utility::IText
	{
	private:
		enum VALUE
		{
			CHARLIST_DEFSIZE = 256,
			CHARLIST_RESIZESTEP = 16,

			LINELIST_DEFSIZE = 32,
			LINELIST_RESIZESTEP = 4,
		};

		typedef Mix::Container<IText::LINE_INFO> LineInfoList;
		typedef Mix::Container<IText::CHARACTER_INFO> CharInfoList;
		typedef Mix::Container<wchar_t> CharList;

	public:
		static Text* CreateInstance( void );

	private:
		Mix::Graphics::Utility::IFont* m_pFont;
		Mix::Point m_Range;
		UInt8 m_Flags;
		Mix::String m_Text;
		CharList m_CharList;
		CharInfoList m_CharInfoList;
		UInt32 m_ModifyCharCount;
		LineInfoList m_LineInfoList;
		Boolean m_bUpdate;

	private:
		Text( void );
		virtual ~Text( void );

		void Reset( void );
		void AddChar( const Mix::Point& pos, wchar_t code, const Mix::Graphics::Utility::IFont::GLYPH& glyph );
		void AddLine( void );

		void DoCenterH( void );
		void DoCenterV( void );

	public:
		virtual void SetFont( Mix::Graphics::Utility::IFont* pFont );
		virtual Mix::Graphics::Utility::IFont* GetFontPtr( void ) const;
		virtual void SetRange( const Mix::Point& range );
		virtual const Mix::Point& GetRange( void ) const;
		virtual void SetText( const wchar_t* pText );
		virtual const wchar_t* GetText( void ) const;
		virtual void SetFlags( UInt8 flags );
		virtual UInt8 GetFlags( void ) const;
		virtual void Update( void );
		virtual UInt32 GetLineCount( void ) const;
		virtual const IText::LINE_INFO* GetLineInfoList( void ) const;
		virtual UInt32 GetCharacterCount( void ) const;
		virtual const IText::CHARACTER_INFO* GetCharacterInfoList( void ) const;
		virtual const wchar_t* GetCharacterList( void ) const;
	};

}}}}
