#include "Mix/Class/Graphics/Utility/Common/Text.h"
#include "Mix/Graphics/Utility/IFont.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

Text* Text::CreateInstance( void )
{
	return new Text();
}

Text::Text( void ) :
m_pFont( NULL ),
m_Range( 512, 512 ),
m_Flags( 0 ),
m_Text( L"" ),
m_ModifyCharCount( 0 ),
m_bUpdate( False )
{
	m_CharList.Initialize( CHARLIST_DEFSIZE, CHARLIST_RESIZESTEP, L"IText\\CharList" );
	m_CharInfoList.Initialize( CHARLIST_DEFSIZE, CHARLIST_RESIZESTEP, L"IText\\CharInfoList" );
	m_LineInfoList.Initialize( LINELIST_DEFSIZE, LINELIST_RESIZESTEP, L"IText\\LineInfoList" );

	Reset();
}

Text::~Text( void )
{
	MIX_RELEASE( m_pFont );
}

void Text::SetFont( Mix::Graphics::Utility::IFont* pFont )
{
	if( m_pFont != pFont )
	{
		MIX_RELEASE( m_pFont );
		m_pFont = pFont;
		MIX_ADD_REF( m_pFont );
		m_bUpdate = True;
	}
}

Mix::Graphics::Utility::IFont* Text::GetFontPtr( void ) const
{
	return m_pFont;
}

void Text::SetRange( const Mix::Point& range )
{
	if( m_Range != range )
	{
		m_Range = range;
		m_bUpdate = True;
	}
}

const Mix::Point& Text::GetRange( void ) const
{
	return m_Range;
}

void Text::SetText( const wchar_t* pText )
{
	if( m_Text != pText )
	{
		m_Text = pText;
		m_bUpdate = True;
	}
}

const wchar_t* Text::GetText( void ) const
{
	return m_Text.GetConstPtr();
}

void Text::SetFlags( UInt8 flags )
{
	if( m_Flags != flags )
	{
		m_Flags = flags;
		m_bUpdate = True;
	}
}

UInt8 Text::GetFlags( void ) const
{
	return m_Flags;
}

void Text::Update( void )
{
	if( ( m_bUpdate == False ) ||
		( m_pFont == NULL ) ||
		( m_Text.GetSize() == 0 ) )
	{
		return;
	}

	Boolean bContinue;
	const wchar_t* pCode;
	Int32 fontHeightI;
	Int32 fontHalfHeightI;
	Int32 tabI;
	Int32 right;
	Int32 bottom;
	Int32 cl, ct, cr, cb;
	Mix::Graphics::Utility::IFont::GLYPH glyph;
	Mix::Point pos;
	IText::CHARACTER_INFO* charInfoList;
	IText::LINE_INFO* pLineInfo;
	IText::LINE_INFO* pLineInfoEnd;

	//
	bContinue = True;
	pCode = &( m_Text[0] );
	fontHeightI = static_cast<Int32>( m_pFont->GetHeight() );
	fontHalfHeightI = ( fontHeightI >> 1 );
	tabI = fontHalfHeightI * STR_TAB_COUNT;
	right = m_Range.x;
	bottom = m_Range.y;
	pos.x = 0;
	pos.y = 0;

	//ɒ[ɏ`͕`悵Ȃ
	if( ( fontHeightI >= m_Range.x ) ||
		( fontHeightI >= m_Range.y ) )
	{
		return;
	}

	//Zbg
	Reset();

	//`p̏쐬
	while( bContinue == True )
	{
		switch( *pCode )
		{
		case L' ':
			if( right <= ( pos.x + fontHalfHeightI ) )
			{
				pos.x = 0;
				pos.y += fontHeightI;
			}
			else
			{
				pos.x += fontHalfHeightI;
			}
			break;
		case L'@':
			if( right <= ( pos.x + fontHeightI ) )
			{
				pos.x = 0;
				pos.y += fontHeightI;
			}
			else
			{
				pos.x += fontHeightI;
			}
			break;
		case L'\t':
			if( right <= ( pos.x + tabI ) )
			{
				pos.x = 0;
				pos.y += fontHeightI;
			}
			else
			{
				pos.x += tabI;
			}
			break;

		case L'\r':
			break;
		case L'\n':
			//sǉ
			AddLine();
			pos.x = 0;
			pos.y += fontHeightI;
			break;

		case L'\0':
			//I
			bContinue = False;
			break;

		default:
			if( m_pFont->GetGlyph( *pCode, glyph ) == True )
			{
				if( right <= ( pos.x + glyph.cellWidth ) )
				{
					if( MIX_TESTBIT( m_Flags, IText::WORDBREAK ) == IText::WORDBREAK )
					{
						//sǉ
						if( bottom > ( pos.y + fontHeightI + fontHeightI ) )
						{
							AddLine();

							pos.x = 0;
							pos.y += fontHeightI;

							//ɒ[ɏ`( ꕶ`łȂ` )w肳Ăꍇɏ邽߁A
							//Oɖ߂A悤ɂ
							pCode--;
						}
						else
						{
							bContinue = False;
						}
					}
					else
					{
						if( MIX_TESTBIT( m_Flags, IText::HCENTER ) == IText::HCENTER )
						{
							//ǉ( ̃Jbg HCENTER ōs );
							AddChar( pos, *pCode, glyph );
							pos.x += glyph.cellWidth;
						}
						else
						{
							//ǉȂ
							pos.x += glyph.cellWidth;
						}
					}
				}
				else
				{
					//ǉ
					AddChar( pos, *pCode, glyph );
					pos.x += glyph.cellWidth;
				}
			}
			else
			{
				//T|[gĂȂ͔pXy[XĂ܂
				if( right <= ( pos.x + fontHalfHeightI ) )
				{
					pos.x = 0;
					pos.y += fontHeightI;
				}
				else
				{
					pos.x += fontHalfHeightI;
				}
			}
		}

		if( bottom <= ( pos.y + fontHeightI ) )
		{
			bContinue = False;
		}

		pCode++;
	}

	//HCENTERs
	if( MIX_TESTBIT( m_Flags, IText::HCENTER ) == IText::HCENTER )
	{
		DoCenterH();
	}

	//VCENTERs
	if( MIX_TESTBIT( m_Flags, IText::VCENTER ) == IText::VCENTER )
	{
		DoCenterV();
	}

	//s̋`ݒ
	charInfoList = m_CharInfoList.GetBeginPtr();
	pLineInfo = m_LineInfoList.GetBeginPtr();
	pLineInfoEnd = m_LineInfoList.GetEndPtr();
	while( pLineInfo != pLineInfoEnd )
	{
		if( pLineInfo->charCount == 0 )
		{
			pLineInfo++;
			continue;
		}

		cl = charInfoList[pLineInfo->charStart].cellBounds.x;
		ct = charInfoList[pLineInfo->charStart].cellBounds.y;
		cr = charInfoList[( pLineInfo->charStart + pLineInfo->charCount - 1 )].cellBounds.GetRight();
		cb = charInfoList[( pLineInfo->charStart + pLineInfo->charCount - 1 )].cellBounds.GetBottom();

		pLineInfo->bounds.x = cl;
		pLineInfo->bounds.y = ct;
		pLineInfo->bounds.width = ( cr - cl );
		pLineInfo->bounds.height = ( cb - ct );

		pLineInfo++;
	}

	//I[R[hĂ
	m_CharList.Add( L'\0' );

	//XV
	m_bUpdate = False;
}

UInt32 Text::GetLineCount( void ) const
{
	return m_LineInfoList.GetCount();
}

const IText::LINE_INFO* Text::GetLineInfoList( void ) const
{
	if( m_LineInfoList.GetCount() == 0 )
	{
		return NULL;
	}

	return m_LineInfoList.GetConstBeginPtr();
}

UInt32 Text::GetCharacterCount( void ) const
{
	return m_CharInfoList.GetCount();
}

const IText::CHARACTER_INFO* Text::GetCharacterInfoList( void ) const
{
	if( m_CharInfoList.GetCount() == 0 )
	{
		return NULL;
	}

	return m_CharInfoList.GetConstBeginPtr();
}

const wchar_t* Text::GetCharacterList( void ) const
{
	if( m_CharList.GetCount() == 0 )
	{
		return NULL;
	}

	return m_CharList.GetConstBeginPtr();
}

void Text::Reset( void )
{
	m_CharList.Clear();
	m_CharInfoList.Clear();
	m_LineInfoList.Clear();
	m_ModifyCharCount = 0;
}

void Text::AddChar( const Mix::Point& pos, wchar_t code, const Mix::Graphics::Utility::IFont::GLYPH& glyph )
{
	UInt32 lineIndex;
	IText::LINE_INFO* pLineInfo;
	IText::CHARACTER_INFO* pCharInfo;

	if( m_LineInfoList.GetCount() == 0 )
	{
		lineIndex = 0;

		pLineInfo = m_LineInfoList.Add();
		pLineInfo->bounds.x = 0;
		pLineInfo->bounds.y = 0;
		pLineInfo->bounds.width = 0;
		pLineInfo->bounds.height = 0;
		pLineInfo->charStart = 0;
		pLineInfo->charCount = 0;
	}
	else
	{
		lineIndex = m_LineInfoList.GetCount() - 1;
		pLineInfo = &( m_LineInfoList[lineIndex] );
	}

	pLineInfo->charCount++;

	m_CharList.Add( code );

	pCharInfo = m_CharInfoList.Add();
	pCharInfo->line = lineIndex;
	pCharInfo->code = code;
	pCharInfo->bounds.x = ( pos.x + glyph.x );
	pCharInfo->bounds.y = ( pos.y + glyph.y );
	pCharInfo->bounds.width = glyph.width;
	pCharInfo->bounds.height = glyph.height;
	pCharInfo->cellBounds.x = pos.x;
	pCharInfo->cellBounds.y = pos.y;
	pCharInfo->cellBounds.width = glyph.cellWidth;
	pCharInfo->cellBounds.height = glyph.cellHeight;

	m_ModifyCharCount++;
}

void Text::AddLine( void )
{
	IText::LINE_INFO* pLineInfo = m_LineInfoList.Add();

	pLineInfo->bounds.x = 0;
	pLineInfo->bounds.y = 0;
	pLineInfo->bounds.width = 0;
	pLineInfo->bounds.height = 0;
	pLineInfo->charStart = m_CharInfoList.GetCount();
	pLineInfo->charCount = 0;
}

void Text::DoCenterH( void )
{
	if( m_ModifyCharCount == 0 )
	{
		return;
	}

	IText::LINE_INFO* pLineInfo;
	IText::LINE_INFO* pLineInfoEnd;
	IText::CHARACTER_INFO* charInfoList;
	IText::CHARACTER_INFO* pCharInfo;
	IText::CHARACTER_INFO* pCharInfoEnd;
	UInt32 ct;
	UInt32 cb;
	Int32 shift;
	Int32 left;
	Int32 right;
	Int32 len;

	charInfoList = m_CharInfoList.GetBeginPtr();
	pLineInfo = m_LineInfoList.GetBeginPtr();
	pLineInfoEnd = m_LineInfoList.GetEndPtr();

	while( pLineInfo != pLineInfoEnd )
	{
		left = 10000;
		right = 0;

		if( pLineInfo->charCount > 0 )
		{
			//s̉̒v
			pCharInfo = &( charInfoList[pLineInfo->charStart] );
			pCharInfoEnd = ( pCharInfo + pLineInfo->charCount );
			while( pCharInfo != pCharInfoEnd )
			{
				left = min( left, pCharInfo->cellBounds.x );
				right = max( right, pCharInfo->cellBounds.GetRight() );
				pCharInfo++;
			}

			//s̒
			len = ( right - left );

			//͂ݏoĂꍇ́AO̕
			if( m_Range.x <= len )
			{
				ct = pLineInfo->charStart;
				cb = ( ct + pLineInfo->charCount - 1 );

				for( ;; )
				{
					len -= charInfoList[cb].cellBounds.width;
					cb--;
					m_ModifyCharCount--;

					if( ( m_Range.x > len ) ||
						( ct > cb ) )
					{
						break;
					}
/*
					len -= charInfoList[ct].bounds.width;
					ct++;
					m_ModifyCharCount--;

					if( m_Range.x > len )
					{
						break;
					}
*/				}

				pLineInfo->charStart = ct;
				pLineInfo->charCount = ( ct <= cb )? ( cb - ct + 1 ) : 0;
			}

			//ɂ悹
			if( pLineInfo->charCount > 0 )
			{
				pCharInfo = &( charInfoList[pLineInfo->charStart] );
				pCharInfoEnd = ( pCharInfo + pLineInfo->charCount );
				shift = ( ( 0 - pCharInfo->bounds.x ) + ( ( m_Range.x - len ) >> 1 ) );
				while( pCharInfo != pCharInfoEnd )
				{
					pCharInfo->bounds.x += shift;
					pCharInfo->cellBounds.x += shift;
					pCharInfo++;
				}
			}
		}

		pLineInfo++;
	}
}

void Text::DoCenterV( void )
{
	IText::LINE_INFO* pLineInfo;
	IText::LINE_INFO* pLineInfoEnd;
	IText::CHARACTER_INFO* charInfoList;
	IText::CHARACTER_INFO* pCharInfo;
	IText::CHARACTER_INFO* pCharInfoEnd;
	Int32 top;
	Int32 bottom;
	Int32 offset;

	top = 10000;
	bottom = 0;

	charInfoList = m_CharInfoList.GetBeginPtr();
	pLineInfo = m_LineInfoList.GetBeginPtr();
	pLineInfoEnd = m_LineInfoList.GetEndPtr();

	while( pLineInfo != pLineInfoEnd )
	{
		pCharInfo = &( charInfoList[pLineInfo->charStart] );
		pCharInfoEnd = ( pCharInfo + pLineInfo->charCount );
		while( pCharInfo != pCharInfoEnd )
		{
			top = min( top, pCharInfo->cellBounds.y );
			bottom = max( bottom, pCharInfo->cellBounds.GetBottom() );

			pCharInfo++;
		}

		pLineInfo++;
	}

	offset = ( ( 0 - top ) + ( ( m_Range.y - ( bottom - top ) ) >> 1 ) );

	pLineInfo = m_LineInfoList.GetBeginPtr();
	pLineInfoEnd = m_LineInfoList.GetEndPtr();
	while( pLineInfo != pLineInfoEnd )
	{
		pCharInfo = &( charInfoList[pLineInfo->charStart] );
		pCharInfoEnd = ( pCharInfo + pLineInfo->charCount );
		while( pCharInfo != pCharInfoEnd )
		{
			pCharInfo->bounds.y += offset;
			pCharInfo->cellBounds.y += offset;
			pCharInfo++;
		}

		pLineInfo++;
	}
}

}}}}
