#pragma once

#include "Mix/Graphics/Utility/ITargetTextureChain.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

	class TargetTextureChain : public Mix::Graphics::Utility::ITargetTextureChain
	{
	private:
		enum VALUE
		{
			TT_CURRENT	= 0,
			TT_NEXT		= 1,
			TT_MAX		= 2,
		};

	public:
		static TargetTextureChain* CreateInstance( void );

	private:
		UInt32 m_Current;
		UInt32 m_Next;
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::ITexture* m_pTargetTexture[TargetTextureChain::TT_MAX];

	private:
		TargetTextureChain( void );
		virtual ~TargetTextureChain( void );

	public:
		Boolean Initialize( Mix::Graphics::IDevice* pDevice, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, const wchar_t* pName );

	public:
		virtual Mix::Graphics::ITexture* GetCurrentPtr( void ) const;
		virtual Mix::Graphics::ITexture* GetNextPtr( void ) const;
		virtual Mix::Graphics::ITexture* GetNextPtrAndFlip( void );
		virtual void Flip( void );

		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
	};

}}}}
