#include "Mix/Class/Graphics/Utility/Common/TargetTextureChain.h"
#include "Mix/Graphics/IDevice.h"
#include "Mix/Graphics/ITexture.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

TargetTextureChain* TargetTextureChain::CreateInstance( void )
{
	return new TargetTextureChain();
}

TargetTextureChain::TargetTextureChain( void ) :
m_Current( TargetTextureChain::TT_CURRENT ),
m_Next( TargetTextureChain::TT_NEXT ),
m_Width( 0 ),
m_Height( 0 )
{
	for( UInt32 i = 0; i < TargetTextureChain::TT_MAX; i++ )
	{
		m_pTargetTexture[i] = NULL;
	}
}

TargetTextureChain::~TargetTextureChain( void )
{
	for( UInt32 i = 0; i < TargetTextureChain::TT_MAX; i++ )
	{
		MIX_RELEASE( m_pTargetTexture[i] );
	}
}

Boolean TargetTextureChain::Initialize( Mix::Graphics::IDevice* pDevice, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, const wchar_t* pName )
{
	Mix::StringW temp;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// TCYݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_Width = width;
	m_Height = height;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ^[QbgeNX`쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	for( UInt32 i = 0; i < TargetTextureChain::TT_MAX; i++ )
	{
		temp.Sprintf( L"%s.Texture%d", pName, i );

		if( pDevice->CreateTargetTexture( width, height, format, &( m_pTargetTexture[i] ), temp.GetConstPtr() ) == False )
		{
			return False;
		}
	}

	return True;
}

Mix::Graphics::ITexture* TargetTextureChain::GetCurrentPtr( void ) const
{
	return m_pTargetTexture[m_Current];
}

Mix::Graphics::ITexture* TargetTextureChain::GetNextPtr( void ) const
{
	return m_pTargetTexture[m_Next];
}

Mix::Graphics::ITexture* TargetTextureChain::GetNextPtrAndFlip( void )
{
	Mix::Graphics::ITexture* pTexture = m_pTargetTexture[m_Next];

	Flip();

	return pTexture;
}

void TargetTextureChain::Flip( void )
{
	m_Current = ( m_Current + 1 ) % TargetTextureChain::TT_MAX;
	m_Next = ( m_Next + 1 ) % TargetTextureChain::TT_MAX;
}

UInt32 TargetTextureChain::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TargetTextureChain::GetHeight( void ) const
{
	return m_Height;
}

}}}}
