#pragma once

#include "Mix/Graphics/Utility/IFont.h"

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

	class Font : public Mix::Graphics::Utility::IFont
	{
	private:
		//t@Cwb_\
		struct FILE_HEADER
		{
			UInt32 magicNumber;
			UInt32 version;
		};

		//f[^wb_\
		struct DATA_HEADER
		{
			UInt32	bufferSize;
			wchar_t	firstCode;
			wchar_t	lastCode;
			UInt32	height;
			UInt32	weight;
			UInt8	bitCount;
			UInt8	reserve[7];
		};

		//LN^[
		struct CHARA_INFO
		{
			UInt32	imgAddr;
			UInt32	imgPitch;
			UInt16	cellWidth;
			UInt16	cellHeight;
			Int16	x;
			Int16	y;
			UInt16	width;
			UInt16	height;
			UInt16	reserve[2];
		};

	public:
		static Boolean CheckFormat( Mix::Memory::IBuffer* pBuffer );
		static Font* CreateInstance( Mix::Memory::IBuffer* pBuffer );

	private:
		Mix::Memory::IBuffer* m_pBuffer;
		const UInt8* m_pData;

		const FILE_HEADER* m_pFileHeader;
		const DATA_HEADER* m_pDataHeader;
		const CHARA_INFO* m_pCharaInfoArray;

	private:
		Font( Mix::Memory::IBuffer* pBuffer );
		virtual ~Font( void );

	public:
		virtual Boolean GetGlyph( wchar_t code, Mix::Graphics::Utility::IFont::GLYPH& glyph ); 
		virtual UInt32 GetHeight( void ) const;
		virtual UInt32 GetWeight( void ) const;

	private:
		static const UInt32 FNT_MAGICNUMBER;
		static const UInt32 FNT_VERSION;
	};

}}}}
