#pragma once

#include "Mix/Graphics/Utility/ICanvas.h"
#include "Mix/Class/Container.h"
#include "Mix/Class/Stack.h"

namespace Mix{ namespace Graphics{ namespace Common{
	class Manager;
}}}

namespace Mix{ namespace Graphics{ namespace Utility{ namespace Common{

	class TextPrinter;

	class Canvas : public Mix::Graphics::Utility::ICanvas
	{
	private:
		enum VALUE
		{
			TEXTTEX_SIZE				= 512,							//eLXgeNX`̃TCY
			TEXTTEX_DEFCOUNT			= 2,							//eLXgeNX`̃ftHg

			CLIPSTACK_DEFSIZE			= 16,							//NbvX^bÑftHgTCY
			CLIPSTACK_RESIZESTEP		= 4,							//NbvX^bÑTCYXebv

			MATRIXSTACK_DEFSIZE			= 16,							//sX^bÑftHgTCY
			MATRIXSTACK_RESIZESTEP		= 4,							//sX^bÑTCYXebv

			QUAD_DEF_SIZE				= 512,							//Nbh̃ftHgTCY
			QUAD_DEF_RESIZESTEP			= 32,							//Nbh̃TCYXebv

			ENTRYLIST_DEFSIZE			= 128,							//Gg[Xg̃ftHgTCY
			ENTRYLIST_RESIZESTEP		= 8,							//Gg[Xg̃TCYXebv

			OBJECTLIST_DEFSIZE			= ( QUAD_DEF_SIZE ),			//IuWFNgXg̃ftHgTCY
			OBJECTLIST_RESIZESTEP		= ( QUAD_DEF_RESIZESTEP ),		//IuWFNgXg̃TCYXebv

			VERTEXLIST_DEFSIZE			= ( QUAD_DEF_SIZE * 4 ),		//_Xg̃ftHgTCY
			VERTEXLIST_RESIZESTEP		= ( QUAD_DEF_RESIZESTEP * 4 ),	//_Xg̃TCYXebv

			VERTEXBUFFER_DEFSIZE		= ( QUAD_DEF_SIZE * 4 ),		//_obt@̃ftHgTCY
			VERTEXBUFFER_RESIZESTEP		= ( QUAD_DEF_RESIZESTEP * 4 ),	//_obt@̃TCYXebv

			INDEXBUFFER_DEFSIZE			= ( QUAD_DEF_SIZE * 6 ),		//CfbNXobt@̃ftHgTCY
			INDEXBUFFER_RESIZESTEP		= ( QUAD_DEF_RESIZESTEP * 6 ),	//CfbNXobt@̃TCYXebv
		};

		//Gg[\
		struct ENTRY
		{
			Mix::Rectangle clip;

			Mix::Graphics::BLEND_TYPE bt;
			Mix::Graphics::ITexture* tex;

			Mix::Graphics::PRIMITIVE_TYPE pt;
			UInt32 startVertex;
			UInt32 numVertex;
			UInt32 startIndex;
			UInt32 numIndex;
			UInt32 reserve;
		};

		//IuWFNg\
		struct OBJECT
		{
			Mix::Graphics::PRIMITIVE_TYPE type;
			UInt16 numVertex;
			UInt16 count;
		};

		//_\
		struct VERTEX
		{
			Mix::Vector4 pos;
			Mix::Vector4 color;
			Mix::Vector2 tex;
		};

	public:
		static Canvas* CreateInstance( const wchar_t* pName );

	private:
		Mix::StringW m_Name;

		Mix::Graphics::IDevice* m_pDevice;

		Mix::Graphics::Utility::IFont* m_pFont;
		Mix::Vector4 m_Color;
		Mix::Graphics::BLEND_TYPE m_BlendType;

		Boolean m_bIdentityMatrix;
		Mix::Matrix3x3 m_Matrix;
		Mix::Stack<Mix::Matrix3x3> m_MatrixStack;

		Boolean m_bClipEnabled;
		Mix::Rectangle m_Clip;
		Mix::Stack<Mix::Rectangle> m_ClipStack;

		Mix::Graphics::Utility::Common::TextPrinter* m_pTextPrinter;

		Mix::Container<Canvas::ENTRY> m_EntryList;
		Mix::Container<Canvas::OBJECT> m_ObjectList;
		Mix::Container<Canvas::VERTEX> m_VertexList;

		UInt32 m_TransformVertexStart;
		UInt32 m_TransformVertexCount;

		Mix::Graphics::IVertexLayout* m_pVertexLayout;
		Mix::Graphics::IVertexShader* m_pVertexShader;
		Mix::Graphics::IPixelShader* m_pPixelShader[2];
		Mix::Graphics::IVertexBuffer* m_pVertexBuffer;
		Mix::Graphics::IIndexBuffer* m_pIndexBuffer;

	private:
		Canvas( const wchar_t* pDebugName );
		virtual ~Canvas( void );

		void PushEntry( Mix::Graphics::PRIMITIVE_TYPE type, Mix::Graphics::ITexture* pTexture );
		VERTEX* PushVertex( UInt16 numVertex, UInt16 numUnit );
		void TransformVertex( void );

		void UpdateVertexBuffer( void );
		void UpdateIndexBuffer( void );

	public:
		Boolean Initialize( Mix::Graphics::Common::Manager* pManager );

	public:
		virtual Boolean GetFont( Mix::Graphics::Utility::IFont** ppFont ) const;
		virtual void SetFont( Mix::Graphics::Utility::IFont* pFont );

		virtual const Mix::Vector4& GetColor( void ) const;
		virtual void SetColor( const Mix::Vector4& color );

		virtual Mix::Graphics::BLEND_TYPE GetBlendType( void ) const;
		virtual void SetBlendType( Mix::Graphics::BLEND_TYPE type );

		virtual const Mix::Matrix3x3& GetMatrix( void ) const;
		virtual void SetMatrix( const Mix::Matrix3x3& mat );
		virtual UInt32 PushMatrix( void );
		virtual UInt32 PopMatrix( void );
		virtual UInt32 DrainMatrix( void );

		virtual const Mix::Rectangle& GetClip( void ) const;
		virtual void SetClip( Int32 x, Int32 y, Int32 width, Int32 height );
		virtual void SetClip( const Mix::Rectangle& rect );
		virtual UInt32 PushClip( void );
		virtual UInt32 PopClip( void );
		virtual UInt32 DrainClip( void );

		virtual void AddLine( const Mix::Vector2& p1, const Mix::Vector2& p2 );
		virtual void AddLines( const Mix::Vector2 points[], UInt16 numPoints );

		virtual void AddRectangle( const Mix::RectangleF& rect );
		virtual void AddPolygon( const Mix::Vector2 points[], UInt16 numPoints );

		virtual void AddFillRectangle( const Mix::RectangleF& rect );
		virtual void AddFillPolygon( const Mix::Vector2 points[], UInt16 numPoints );

		virtual void AddImage( Mix::Graphics::ITexture* pTexture, Float32 dx, Float32 dy, Float32 width, Float32 height, Float32 sx, Float32 sy );
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, const Mix::RectangleF& dst, const Mix::Vector2& src );
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, Float32 dx, Float32 dy, Float32 dw, Float32 dh, Float32 sx, Float32 sy, Float32 sw, Float32 sh );
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, const Mix::RectangleF& dst, const Mix::RectangleF& src );

		virtual void AddString( Float32 x, Float32 y, const wchar_t* str );
		virtual void AddString( const Mix::Vector2& pos, const wchar_t* str );

		virtual void AddText( Float32 x, Float32 y, Mix::Graphics::Utility::IText* pText );
		virtual void AddText( const Mix::Vector2& pos, Mix::Graphics::Utility::IText* pText );

		virtual void Update( void );
		virtual void Draw( void );
	};

}}}}
