#include "Mix/Class/Graphics/DX9/VertexShader.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

VertexShader* VertexShader::CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader, const wchar_t* pName )
{
	return new VertexShader( pDevice, pVertexShader, pName );
}

VertexShader::VertexShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DVertexShader9* pVertexShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_VERTEXSHADER, False, pName ),
m_pVertexShader( pVertexShader )
{
}

VertexShader::~VertexShader( void )
{
	MIX_RELEASE( m_pVertexShader );
}

IDirect3DVertexShader9* VertexShader::GetInsterface( void )
{
	return m_pVertexShader;
}

}}}
