#pragma once

#include <vector>

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexLayout.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class VertexLayout : public Mix::Graphics::IVertexLayout, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static VertexLayout* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												IDirect3DVertexDeclaration9* pVertexLayout,
												const Mix::Graphics::VERTEX_ELEMENT* pElements,
												UInt32 elementCount,
												UInt32 stride,
												const wchar_t* pName );

	private:
		IDirect3DVertexDeclaration9* m_pVertexLayout;
		std::vector<Mix::Graphics::VERTEX_ELEMENT> m_ElementList;
		UInt32 m_ElementSemanticFlags;
		UInt32 m_Stride;

	private:
		VertexLayout(	Mix::Graphics::DX9::Device* pDevice,
						IDirect3DVertexDeclaration9* pVertexLayout,
						const Mix::Graphics::VERTEX_ELEMENT* pElements,
						UInt32 elementCount,
						UInt32 stride,
						const wchar_t* pName );

		virtual ~VertexLayout( void );

	public:
		virtual UInt32 GetElementCount( void ) const;
		virtual const Mix::Graphics::VERTEX_ELEMENT* GetElements( void ) const;
		virtual UInt32 GetElementSemanticFlags( void ) const;
		virtual UInt32 GetStride( void ) const;

	public:
		IDirect3DVertexDeclaration9* GetInterface( void );
	};

}}}
