#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Class/Graphics/DX9/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class TextureTarget : public Mix::Graphics::DX9::Texture, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static TextureTarget* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat,
												const wchar_t* pName );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		IDirect3DTexture9* m_pTexture;
		IDirect3DSurface9* m_pSurface;
		D3DFORMAT m_D3DFormat;

	private:
		TextureTarget(	Mix::Graphics::DX9::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat,
						const wchar_t* pName );

		virtual ~TextureTarget( void );

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		virtual IDirect3DBaseTexture9* GetInterface( void );
		virtual IDirect3DSurface9* GetSurface( UInt32 index );
		virtual UInt32 GetSurfaceCount( void ) const;

		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo );
		virtual void Unlock( void );
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual TEXTURE_TYPE GetType( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual Boolean IsAvailable( void ) const;
	};

}}}
