#include "Mix/Class/Graphics/DX9/TextureTarget.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

TextureTarget* TextureTarget::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat,
												const wchar_t* pName )
{
	return new TextureTarget( pDevice, width, height, format, pTexture, pSurface, d3dFormat, pName );
}

TextureTarget::TextureTarget(	Mix::Graphics::DX9::Device* pDevice,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat,
								const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_TARGET, False, pName ),
m_pDevice( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pSurface( pSurface ),
m_D3DFormat( d3dFormat )
{
	MIX_ADD_REF( m_pDevice );
}

TextureTarget::~TextureTarget( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

void TextureTarget::Invalidate( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pTexture );
}

void TextureTarget::Validate( void )
{
	HRESULT ret;

	ret = m_pDevice->CreateTargetTexture( m_Width, m_Height, m_D3DFormat, &m_pTexture );
	if( ret == D3D_OK )
	{
		ret = m_pTexture->GetSurfaceLevel( 0, &m_pSurface );
		if( ret != D3D_OK )
		{
			MIX_LOG_ERROR( L"^[QbgeNX`̕AɎs : GetSurfaceLevel G[Ԃ܂ : Name[%s] Result[%s]", GetName(), m_pDevice->GetD3DResultText( ret ) );
		}
	}
	else
	{
		MIX_LOG_ERROR( L"^[QbgeNX`̕AɎs : Name[%s] Result[%s]", GetName(), m_pDevice->GetD3DResultText( ret ) );
	}
}

IDirect3DBaseTexture9* TextureTarget::GetInterface( void )
{
	return m_pTexture;
}

IDirect3DSurface9* TextureTarget::GetSurface( UInt32 index )
{
	return m_pSurface;
}

UInt32 TextureTarget::GetSurfaceCount( void ) const
{
	return 1;
}

Boolean TextureTarget::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureTarget::Unlock( void )
{
}

UInt32 TextureTarget::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureTarget::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::TEXTURE_TYPE TextureTarget::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_TARGET;
}

Mix::Graphics::FORMAT TextureTarget::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureTarget::IsAvailable( void ) const
{
	return ( ( m_pTexture != NULL ) && ( m_pSurface != NULL ) );
}

}}}
