#include "Mix/Class/Graphics/DX9/TextureDepth.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

TextureDepth* TextureDepth::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DSurface9* pSurface,
											const wchar_t* pName )
{
	return new TextureDepth( pDevice, width, height, format, d3dFormat, pSurface, pName );
}

TextureDepth::TextureDepth(	Mix::Graphics::DX9::Device* pDevice,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							D3DFORMAT d3dFormat, IDirect3DSurface9* pSurface,
							const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_DS, False, pName ),
m_pDevice( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_D3DFormat( d3dFormat ),
m_pSurface( pSurface )
{
	MIX_ADD_REF( m_pDevice );
}

TextureDepth::~TextureDepth( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pDevice );
}

IDirect3DBaseTexture9* TextureDepth::GetInterface( void )
{
	return NULL;
}

IDirect3DSurface9* TextureDepth::GetSurface( UInt32 index )
{
	return m_pSurface;
}

UInt32 TextureDepth::GetSurfaceCount( void ) const
{
	return 1;
}

void TextureDepth::Invalidate( void )
{
	MIX_RELEASE( m_pSurface );
}

void TextureDepth::Validate( void )
{
	HRESULT ret;
	
	ret = m_pDevice->CreateDepthTexture( m_Width, m_Height, m_D3DFormat, &m_pSurface );
	if( ret != D3D_OK )
	{
		MIX_LOG_ERROR( L"fvXeNX`̕AɎs : Name[%s] Result[%s]", GetName(), m_pDevice->GetD3DResultText( ret ) );
	}
}

Boolean TextureDepth::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureDepth::Unlock( void )
{
}

UInt32 TextureDepth::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureDepth::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::TEXTURE_TYPE TextureDepth::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_DEPTH;
}

Mix::Graphics::FORMAT TextureDepth::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureDepth::IsAvailable( void ) const
{
	return ( m_pSurface != NULL );
}

}}}
