#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Class/Graphics/DX9/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class TextureCube : public Mix::Graphics::DX9::Texture, public Mix::Graphics::Common::DeviceObject
	{
	private:
		static const D3DCUBEMAP_FACES D3DFACE_TABLE[Mix::Graphics::CUBEMAP_FACE_MAX];

	public:
		static TextureCube* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											Boolean bFile, UInt32 edgeLength, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture,
											const wchar_t* pName );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		Boolean m_bFile;
		UInt32 m_EdgeLength;
		Mix::Graphics::FORMAT m_Format;
		D3DFORMAT m_D3DFormat;
		IDirect3DCubeTexture9* m_pD3DCubeTexture;
		IDirect3DSurface9* m_pD3DSurface[Mix::Graphics::CUBEMAP_FACE_MAX];

	private:
		void GetD3DCubeMapSurface( void );

	private:
		TextureCube(	Mix::Graphics::DX9::Device* pDevice,
						Boolean bFile, UInt32 edgeLength, Mix::Graphics::FORMAT format,
						D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture,
						const wchar_t* pName );

		virtual ~TextureCube( void );

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		virtual IDirect3DBaseTexture9* GetInterface( void );
		virtual IDirect3DSurface9* GetSurface( UInt32 index );
		virtual UInt32 GetSurfaceCount( void ) const;

		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo );
		virtual void Unlock( void );
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::TEXTURE_TYPE GetType( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual Boolean IsAvailable( void ) const;
	};
}}}
