#include "Mix/Class/Graphics/DX9/TextureCube.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

const D3DCUBEMAP_FACES TextureCube::D3DFACE_TABLE[Mix::Graphics::CUBEMAP_FACE_MAX] =
{
	D3DCUBEMAP_FACE_POSITIVE_X,
	D3DCUBEMAP_FACE_NEGATIVE_X,
	D3DCUBEMAP_FACE_POSITIVE_Y,
	D3DCUBEMAP_FACE_NEGATIVE_Y,
	D3DCUBEMAP_FACE_POSITIVE_Z,
	D3DCUBEMAP_FACE_NEGATIVE_Z,
};

TextureCube* TextureCube::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											Boolean bFile, UInt32 edgeLength, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture,
											const wchar_t* pName )
{
	return new TextureCube( pDevice, bFile, edgeLength, format, d3dFormat, pD3DCubeTexture, pName );
}

TextureCube::TextureCube(	Mix::Graphics::DX9::Device* pDevice,
							Boolean bFile, UInt32 edgeLength, Mix::Graphics::FORMAT format,
							D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture,
							const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_CUBE, bFile, pName ),
m_pDevice( pDevice ),
m_bFile( bFile ),
m_EdgeLength( edgeLength ),
m_Format( format ),
m_D3DFormat( d3dFormat ),
m_pD3DCubeTexture( pD3DCubeTexture )
{
	UInt32 i;

	for( i = 0; i < Mix::Graphics::CUBEMAP_FACE_MAX; i++ )
	{
		m_pD3DSurface[i] = NULL;
	}

	GetD3DCubeMapSurface();
}

TextureCube::~TextureCube( void )
{
	MIX_RELEASE( m_pD3DCubeTexture );

	for( UInt32 i = 0; i < Mix::Graphics::CUBEMAP_FACE_MAX; i++ )
	{
		MIX_RELEASE( m_pD3DSurface[i] );
	}
}

void TextureCube::Invalidate( void )
{
	if( m_bFile == False )
	{
		MIX_RELEASE( m_pD3DCubeTexture );

		for( UInt32 i = 0; i < Mix::Graphics::CUBEMAP_FACE_MAX; i++ )
		{
			MIX_RELEASE( m_pD3DSurface[i] );
		}
	}
}

void TextureCube::Validate( void )
{
	if( m_bFile == False )
	{
		HRESULT ret;

		ret = m_pDevice->CreateCubeTexture( m_EdgeLength, m_D3DFormat, &m_pD3DCubeTexture );
		if( ret == D3D_OK )
		{
			GetD3DCubeMapSurface();
		}
		else
		{
			MIX_LOG_ERROR( L"L[ueNX`̕AɎs : Name[%s] Result[%s]", GetName(), m_pDevice->GetD3DResultText( ret ) );
		}
	}
}

IDirect3DBaseTexture9* TextureCube::GetInterface( void )
{
	return m_pD3DCubeTexture;
}

IDirect3DSurface9* TextureCube::GetSurface( UInt32 index )
{
	MIX_ASSERT( Mix::Graphics::CUBEMAP_FACE_MAX > index );
	return m_pD3DSurface[index];
}

UInt32 TextureCube::GetSurfaceCount( void ) const
{
	return Mix::Graphics::CUBEMAP_FACE_MAX;
}

Boolean TextureCube::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureCube::Unlock( void )
{
}

UInt32 TextureCube::GetWidth( void ) const
{
	return m_EdgeLength;
}

UInt32 TextureCube::GetHeight( void ) const
{
	return m_EdgeLength;
}

Mix::Graphics::TEXTURE_TYPE TextureCube::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_CUBE;
}

Mix::Graphics::FORMAT TextureCube::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureCube::IsAvailable( void ) const
{
	return True;
}

void TextureCube::GetD3DCubeMapSurface( void )
{
	UInt32 i;

	for( i = 0; i < Mix::Graphics::CUBEMAP_FACE_MAX; i++ )
	{
		m_pD3DCubeTexture->GetCubeMapSurface( TextureCube::D3DFACE_TABLE[i], 0, &( m_pD3DSurface[i] ) );
	}
}

}}}
