#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Class/Graphics/DX9/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class Texture2D : public Mix::Graphics::DX9::Texture, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static Texture2D* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DTexture9* pD3DTexture,
											Boolean bRegisterMap, const wchar_t* pName );

	private:
		Mix::Graphics::DX9::Device*	m_pDevice;
		IDirect3DTexture9*			m_pTexture;
		Mix::Graphics::FORMAT		m_Format;
		D3DFORMAT					m_D3DFormat;
		UInt32						m_Width;
		UInt32						m_Height;
		UInt32						m_LockFlags;
		Boolean						m_bDynamic;
		Boolean						m_bLock;

	private:
		Texture2D(	Mix::Graphics::DX9::Device* pDevice,
					Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
					D3DFORMAT d3dFormat, IDirect3DTexture9* pD3DTexture,
					Boolean bRegisterMap, const wchar_t* pName );

		virtual ~Texture2D( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual IDirect3DBaseTexture9* GetInterface( void );
		virtual IDirect3DSurface9* GetSurface( UInt32 index );
		virtual UInt32 GetSurfaceCount( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo );
		virtual void Unlock( void );
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual TEXTURE_TYPE GetType( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual Boolean IsAvailable( void ) const;
	};

}}}
