#include "Mix/Class/Graphics/DX9/Texture2D.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

Texture2D* Texture2D::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
										Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
										D3DFORMAT d3dFormat, IDirect3DTexture9* pD3DTexture,
										Boolean bRegisterMap, const wchar_t* pName )
{
	return new Texture2D( pDevice, bDynamic, width, height, format, d3dFormat, pD3DTexture, bRegisterMap, pName );
}

Texture2D::Texture2D(	Mix::Graphics::DX9::Device* pDevice,
						Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						D3DFORMAT D3DFormat, IDirect3DTexture9* pD3DTexture,
						Boolean bRegisterMap, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_2D, bRegisterMap, pName ),
m_pDevice( pDevice ),
m_bDynamic( bDynamic ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_D3DFormat( D3DFormat ),
m_pTexture( pD3DTexture ),
m_LockFlags( D3DLOCK_DISCARD ),
m_bLock( False )
{
	MIX_ADD_REF( m_pDevice );
}

Texture2D::~Texture2D( void )
{
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

void Texture2D::Invalidate( void )
{
	if( m_bDynamic == False )
	{
		return;
	}

	MIX_RELEASE( m_pTexture );
}

void Texture2D::Validate( void )
{
	if( m_bDynamic == False )
	{
		return;
	}

	HRESULT ret;

	ret = m_pDevice->CreateDynamicTexture( m_Width, m_Height, m_D3DFormat, &m_pTexture );
	if( ret != D3D_OK )
	{
		MIX_LOG_ERROR( L"eNX`̕AɎs : Name[%s] Result[%s]", GetName(), m_pDevice->GetD3DResultText( ret ) );
	}
}

IDirect3DBaseTexture9* Texture2D::GetInterface( void )
{
	return m_pTexture;
}

IDirect3DSurface9* Texture2D::GetSurface( UInt32 index )
{
	return NULL;
}

UInt32 Texture2D::GetSurfaceCount( void ) const
{
	return 0;
}

Boolean Texture2D::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	if( ( m_bDynamic == False ) ||
		( m_bLock == True ) ||
		( m_pTexture == NULL ) )
	{
		return False;
	}

	HRESULT hRet;
	D3DLOCKED_RECT info;

	hRet = m_pTexture->LockRect( 0, &info, NULL, m_LockFlags );
	if( hRet != D3D_OK )
	{
		return False;
	}

	lockInfo.pitch = static_cast<UInt32>( info.Pitch );
	lockInfo.bits = info.pBits;

	m_bLock = True;

	return True;
}

void Texture2D::Unlock( void )
{
	if( ( m_bLock == False ) ||
		( m_pTexture == NULL ) )
	{
		return;
	}

	m_pTexture->UnlockRect( 0 );
	m_bLock = False;
}

UInt32 Texture2D::GetWidth( void ) const
{
	return m_Width;
}

UInt32 Texture2D::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::TEXTURE_TYPE Texture2D::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_2D;
}

Mix::Graphics::FORMAT Texture2D::GetFormat( void ) const
{
	return m_Format;
}

Boolean Texture2D::IsAvailable( void ) const
{
	return ( m_pTexture != NULL );
}

}}}
