#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IQuery.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class Query : public Mix::Graphics::IQuery, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static Query* CreateInstance( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_TYPE type, IDirect3DQuery9* pD3DQuery, const wchar_t* pName );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		Mix::Graphics::QUERY_TYPE m_Type;
		IDirect3DQuery9* m_pD3DQuery;

	private:
		Query( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_TYPE type, IDirect3DQuery9* pD3DQuery, const wchar_t* pName );
		virtual ~Query( void );

	public:
		virtual void Begin( void );
		virtual void End( void );
		virtual Boolean GetData( UInt32& data, Boolean bFlush ) const;
		virtual Mix::Graphics::QUERY_TYPE GetType( void ) const;

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );
	};

}}}
