#include "Mix/Class/Graphics/DX9/Query.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

Query* Query::CreateInstance( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_TYPE type, IDirect3DQuery9* pD3DQuery, const wchar_t* pName )
{
	return new Query( pDevice, type, pD3DQuery, pName );
}

Query::Query( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_TYPE type, IDirect3DQuery9* pD3DQuery, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_QUERY, False, pName ),
m_pDevice( pDevice ),
m_Type( type ),
m_pD3DQuery( pD3DQuery )
{
	MIX_ADD_REF( m_pDevice );
}

Query::~Query( void )
{
	MIX_RELEASE( m_pD3DQuery );
	MIX_RELEASE( m_pDevice );
}

void Query::Begin( void )
{
	if( m_pD3DQuery != NULL )
	{
		m_pD3DQuery->Issue( D3DISSUE_BEGIN );
	}
}

void Query::End( void )
{
	if( m_pD3DQuery != NULL )
	{
		m_pD3DQuery->Issue( D3DISSUE_END );
	}
}

Boolean Query::GetData( UInt32& data, Boolean bFlush ) const
{
	if( m_pD3DQuery == NULL )
	{
		return False;
	}

	HRESULT ret;

	ret = m_pD3DQuery->GetData( &data, sizeof( UInt32 ), ( bFlush == True )? D3DGETDATA_FLUSH : 0 );
	if( ret != S_OK )
	{
		return False;
	}

	return True;
}

Mix::Graphics::QUERY_TYPE Query::GetType( void ) const
{
	return m_Type;
}

void Query::Invalidate( void )
{
	MIX_RELEASE( m_pD3DQuery );
}

void Query::Validate( void )
{
	HRESULT ret;

	ret = m_pDevice->CreateQuery( m_Type, &m_pD3DQuery );
	if( ret == D3D_OK )
	{
		MIX_LOG_INFO( L"NG𕜋A : Type[%s]", m_pDevice->GetQueryText( m_Type ) );
	}
	else
	{
		MIX_LOG_INFO( L"NG̕AɎs : CreateQuery G[Ԃ܂ : Type[%s] Result[%s]", m_pDevice->GetQueryText( m_Type ), m_pDevice->GetD3DResultText( ret ) );
	}
}

}}}

