#include "Mix/Class/Graphics/DX9/PixelShader.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

PixelShader* PixelShader::CreateInstance( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader, const wchar_t* pName )
{
	return new PixelShader( pDevice, pPixelShader, pName );
}

PixelShader::PixelShader( Mix::Graphics::DX9::Device* pDevice, IDirect3DPixelShader9* pPixelShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_PIXELSHADER, False, pName ),
m_pPixelShader( pPixelShader )
{
}

PixelShader::~PixelShader( void )
{
	MIX_RELEASE( m_pPixelShader );
}

IDirect3DPixelShader9* PixelShader::GetInsterface( void )
{
	return m_pPixelShader;
}

}}}
