#pragma once

#include "Mix/Class/Graphics/Common/Manager.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class Manager : public Mix::Graphics::Common::Manager
	{
	public:
		static Manager* CreateInstance( void );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;

	private:
		Manager( void );
		virtual ~Manager( void );

	protected:
		virtual Boolean OnInitialize( const Mix::GRAPHICS_CONFIG& cfg, Mix::UserFile* pSysReport );
		virtual void OnDispose( void );

		virtual Mix::Graphics::Common::Device* GetDevicePtr( void );
		virtual void GetShaderBinary( Common::Manager::SHADER_TYPES type, Common::Manager::SHADER_BINARY& out );
	};

}}}
