#include "Mix/Class/Graphics/DX9/Manager.h"

#include "Mix/IWindow.h"
#include "Mix/Graphics/IVertexShader.h"
#include "Mix/Graphics/IPixelShader.h"
#include "Mix/Class/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager : VF[_[
////////////////////////////////////////////////////////////////////////////////////////////////////

//LoX(VS)
static const UInt8 VS_CANVAS_3[] = {
	#include "Mix/Class/Graphics/Utility/DX9/Shader/3/canvas.vs.inc"
};

//LoX - eNX`(PS)
static const UInt8 PS_CANVAS_COLOR_3[] = {
	#include "Mix/Class/Graphics/Utility/DX9/Shader/3/canvasColor.ps.inc"
};

//LoX - eNX`L(PS)
static const UInt8 PS_CANVAS_COLOR_AND_TEXTURE_3[] = {
	#include "Mix/Class/Graphics/Utility/DX9/Shader/3/canvasColorAndTexture.ps.inc"
};

//C(VS)
static const UInt8 VS_LINE_3[] =
{
	#include "Mix/Class/Graphics/Utility/DX9/Shader/3/line.vs.inc"
};

//C(PS)
static const UInt8 PS_LINE_3[] =
{
	#include "Mix/Class/Graphics/Utility/DX9/Shader/3/line.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager
////////////////////////////////////////////////////////////////////////////////////////////////////

Manager* Manager::CreateInstance( void )
{
	return new Manager();
}

Manager::Manager( void ) :
m_pDevice( NULL )
{
}

Manager::~Manager( void )
{
}

Boolean Manager::OnInitialize( const Mix::GRAPHICS_CONFIG& cfg, Mix::UserFile* pSysReport )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// foCX̍쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_pDevice = Mix::Graphics::DX9::Device::CreateInstance( cfg.bWaitVSync );
	if( m_pDevice == NULL )
	{
		return False;
	}

	if( m_pDevice->Initialize( cfg.shaderModel, cfg.bFullscreen, pSysReport ) == False )
	{
		return False;
	}

	return True;
}

void Manager::OnDispose( void )
{
	if( m_pDevice != NULL )
	{
		m_pDevice->Dispose();
		MIX_RELEASE( m_pDevice );
	}
}

Mix::Graphics::Common::Device* Manager::GetDevicePtr( void )
{
	return m_pDevice;
}

void Manager::GetShaderBinary( Common::Manager::SHADER_TYPES type, Common::Manager::SHADER_BINARY& out )
{
	switch( type )
	{
	case Manager::SHADER_CANVAS_VS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"Canvas(DX9_3)" );
		out.pData = &( VS_CANVAS_3[0] );
		out.dataSize = sizeof( VS_CANVAS_3 );
		break;
	case Manager::SHADER_CANVAS_COLOR_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"CanvasColor(DX9_3)" );
		out.pData = &( PS_CANVAS_COLOR_3[0] );
		out.dataSize = sizeof( PS_CANVAS_COLOR_3 );
		break;
	case Manager::SHADER_CANVAS_COLOR_AND_TEXTURE_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"CanvasColorAndTexture(DX9_3)" );
		out.pData = &( PS_CANVAS_COLOR_AND_TEXTURE_3[0] );
		out.dataSize = sizeof( PS_CANVAS_COLOR_AND_TEXTURE_3 );
		break;

	case Manager::SHADER_LINE_VS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"Line(DX9_3)" );
		out.pData = &( VS_LINE_3[0] );
		out.dataSize = sizeof( VS_LINE_3 );
		break;
	case Manager::SHADER_LINE_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"Line(DX9_3)" );
		out.pData = &( PS_LINE_3[0] );
		out.dataSize = sizeof( PS_LINE_3 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(SM3)" );
	};
}

}}}
