#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IIndexBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class IndexBuffer : public Mix::Graphics::IIndexBuffer, public Mix::Graphics::Common::DeviceObject
	{
	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		IDirect3DIndexBuffer9* m_pIndexBuffer;
		UInt8* m_pBuffer;
		Mix::Graphics::INDEX_TYPE m_Type;
		D3DFORMAT m_Format;
		UInt32 m_Stride;
		UInt32 m_Capacity;
		UInt32 m_Count;
		Boolean m_bDynamic;
		UInt32 m_ResizeStep;
		UInt32 m_LockFlags;
		UInt8* m_pSource;
		Boolean m_bResize;

	public:
		static IndexBuffer* CreateInstance( Mix::Graphics::DX9::Device* pDevice,
											Mix::Graphics::INDEX_TYPE type,
											D3DFORMAT format,
											UInt32 count,
											UInt32 resizeStep,
											Boolean bDynamic,
											IDirect3DIndexBuffer9* pIndexBuffer,
											const wchar_t* pName );

	private:
		IndexBuffer(	Mix::Graphics::DX9::Device* pDevice,
						Mix::Graphics::INDEX_TYPE type,
						D3DFORMAT format,
						UInt32 count,
						UInt32 resizeStep,
						Boolean bDynamic,
						IDirect3DIndexBuffer9* pIndexBuffer,
						const wchar_t* pName );

		virtual ~IndexBuffer( void );

	public:
		HRESULT Initialize( const void* pInitialData );
		IDirect3DIndexBuffer9* GetInterface( void );

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );

		virtual Boolean Push( const void* pData, UInt32 count );
		virtual void* Push( UInt32 count );

		virtual void Clear( void );

		virtual Mix::Graphics::INDEX_TYPE GetType( void ) const;

		virtual UInt32 GetCount( void ) const;
		virtual UInt32 GetCapacity( void ) const;

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );
	};

}}}
