#pragma once

#include <list>
#include <map>

#include "Mix/Module.h"
#include "Mix/Semaphore.h"
#include "Mix/CriticalSection.h"
#include "Mix/Class/Graphics/Common/Device.h"

namespace Mix{
	class UserFile;
}

namespace Mix{ namespace Graphics{ namespace DX9{

	class DeviceObject;
	class VertexLayout;
	class VertexShader;
	class PixelShader;
	class Texture2D;

	class Device : public Mix::Graphics::Common::Device
	{
	public:
		//p[^
		struct PARAM
		{
			Boolean windowed;
			Boolean waitVSync;
		};

	private:
		//D3D : o[ebNXCAEg̃Z}eBbN^Cve[u
		static const UInt8 D3DVLSemanticTypeTable[Mix::Graphics::VERTEX_ELEMENT_SEMANTIC_MAX];
		//D3D : o[ebNXCXg̃tH[}bge[u
		static const UInt8 D3DVLFormatTable[Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX];
		//D3D : tH[}bgeLXgz
		static const wchar_t* D3DFormatTextArray[20];
		//D3D : UgeLXgz
		static const wchar_t* D3DResultTextArray[7];
		//D3D : JO[he[u
		const static UInt32 D3DCullModeTable[3];
		//D3D : Zt@NVe[u
		const static UInt32 D3DZFuncTable[Mix::Graphics::ZFUNC_MAX];
		//D3D : v~eBu^Cve[u
		static const D3DPRIMITIVETYPE D3DPrimitiveTypeTable[Mix::Graphics::PT_MAX];
		//D3D : NG^Cve[u
		static const D3DQUERYTYPE D3DQueryTypeTable[Mix::Graphics::QT_MAX];
		//D3D : NGe[u
		static const wchar_t* D3DQueryTextTable[Mix::Graphics::QT_MAX];

		//Xe[^X
		enum STATUS
		{
			STATUS_OK					= 0,	//
			STATUS_CHANGE_WINDOW		= 1,
			STATUS_CHANGE_FULLSCREEN	= 2,
			STATUS_LOST					= 3,
		};

		//tO
		enum FLAG
		{
			FLAG_MODE_WINDOW			= 0x00000001,	//[h : EBhE
			FLAG_MODE_FULLSCREEN		= 0x00000002,	//[h : tXN[

			FLAG_RESOURCE_TEXTURE		= 0x00000010,	//\[X : eNX`
			FLAG_RESOURCE_CUBE			= 0x00000020,	//\[X : L[u
			FLAG_RESOURCE_TARGET		= 0x00000040,	//\[X : ^[Qbg
			FLAG_RESOURCE_DEPTHSTENCIL	= 0x00000080,	//\[X : fvXXeV
		};

		//_[Xe[g^Cv
		enum RENDERSTATETYPE
		{
			RENDERSTATETYPE_FILLMODE			= 0,	//tB[h
			RENDERSTATETYPE_CULLMODE			= 1,	//JO[h
			RENDERSTATETYPE_SCISSORTESTENABLE	= 2,	//VU[eXg
			RENDERSTATETYPE_MULTISAMPLE			= 3,	//}`Tv
			RENDERSTATETYPE_ZENABLE				= 4,	//Zobt@
			RENDERSTATETYPE_ZWRITEENABLE		= 5,	//Zobt@̏
			RENDERSTATETYPE_ZFUNC				= 6,	//Zt@NV
			RENDERSTATETYPE_ALPHABLENDENABLE	= 7,	//At@uh
			RENDERSTATETYPE_SRCBLEND			= 8,	//uh[h(SrcColor)
			RENDERSTATETYPE_DESTBLEND			= 9,	//uh[h(DestColor)
			RENDERSTATETYPE_BLENDOP				= 10,	//uhIy[V(Color)
			RENDERSTATETYPE_SRCBLEND_ALPHA		= 11,	//uh[h(SrcAlpha)
			RENDERSTATETYPE_DESTBLEND_ALPHA		= 12,	//uh[h(DestAlpha)
			RENDERSTATETYPE_BLENDOP_ALPHA		= 13,	//uhIy[V(Alpha)
			RENDERSTATETYPE_WRITECOLOR			= 14,	//J[̏

			RENDERSTATETYPE_MAX					= 15,	//_[Xe[gő吔
		};

		//Tv[Xe[g^Cv
		enum SAMPLERSTATETYPE
		{
			SAMPLERSTATETYPE_MAGFILTER	= 0,	//gtB^[
			SAMPLERSTATETYPE_MINFILTER	= 1,	//ktB^[
			SAMPLERSTATETYPE_MIPFILTER	= 2,	//~bvtB^[
			SAMPLERSTATETYPE_ADDRESSU	= 3,	//UW̃AhbVO[h
			SAMPLERSTATETYPE_ADDRESSV	= 4,	//VW̃AhbVO[h
			SAMPLERSTATETYPE_ADDRESSW	= 5,	//WW̃AhbVO[h
			SAMPLERSTATETYPE_ANISOTROPY	= 6,	//ٕ

			SAMPLERSTATETYPE_MAX		= 7,	//Tv[Xe[gő吔
		};

		//tH[}bg\
		struct FORMATINFO
		{
			D3DFORMAT	format;	//A_v^tH[}bg
			UInt32		flags;	//ΉĂ郊\[X( FLAG_SURFACE, FLAG_TEXTURE, FLAG_TARGET )
		};

		//foCXR{\
		struct DEVICECOMBO
		{
			UInt32		flags;
			D3DFORMAT	adapterFormat;
			D3DFORMAT	backBufferFormat;
			FORMATINFO	formatTable[Mix::Graphics::FMT_MAX];
		};

		//fBXvC[h̃\[gp\
		struct SORT_DISPLAYMODE
		{
			BOOL operator()( const D3DDISPLAYMODE& l, const D3DDISPLAYMODE& r ) const
			{
				if( l.Width > r.Width )
				{
					return FALSE;
				}
				if( l.Width < r.Width )
				{
					return TRUE;
				}
				if(	l.Height > r.Height )
				{
					return FALSE;
				}
				if( l.Height < r.Height )
				{
					return TRUE;
				}
				if( l.Format > r.Format )
				{
					return TRUE;
				}
				if( l.Format < r.Format )
				{
					return FALSE;
				}
				if( l.RefreshRate > r.RefreshRate )
				{
					return FALSE;
				}
				if( l.RefreshRate < r.RefreshRate )
				{
					return TRUE;
				}

				return FALSE;
			}
		};

		//foCXp[^
		struct DEVICEPARAM
		{
			struct
			{
				const FORMATINFO*		formatTable;			//tH[}bge[u
				Mix::Point				screenSize;				//XN[TCY
				D3DPRESENT_PARAMETERS	params;					//vZgp[^
			}current, next;
		};

		//^[QbgXe[g\
		struct TARGETSTATE
		{
			Mix::Rectangle rect;
			Mix::Graphics::ITexture* pTex[Mix::Graphics::TARGET_MAX];
			Mix::Graphics::ITexture* pDSTex;
		};

		//_[Xe[g\
		struct RENDERSTATE
		{
			D3DRENDERSTATETYPE type;
			UInt32 defValue;
			UInt32 value;
		};

		//Tv[Xe[g\
		struct SAMPLERSTATE
		{
			D3DSAMPLERSTATETYPE type;
			UInt32 defValue;
			UInt32 value;
		};

		//`Xe[g\
		struct DRAWSTATE
		{
			struct
			{
				Mix::Graphics::IVertexLayout* pVertexLayout;
				Mix::Graphics::IVertexShader* pVertexShader;
				Mix::Graphics::IPixelShader* pPixelShader;
				Mix::Graphics::IVertexBuffer* pVertexBuffer;
				Mix::Graphics::IIndexBuffer* pIndexBuffer;

			}current, next;

			Mix::Graphics::ITexture* textureTable[Mix::Graphics::TEXTURESTAGE_MAX];
		};

		//fBXvC[hXg
		typedef std::list<D3DDISPLAYMODE> DisplayModeList;
		//foCXR{Xg
		typedef std::list<DEVICECOMBO> DeviceComboList;

		//D3DX֐̒` : D3DXGetImageInfoFromFileInMemory
		typedef HRESULT ( WINAPI *D3DXGetImageInfoFromFileInMemoryFunc )( LPCVOID pSrcData,
			UINT SrcDataSize,
			D3DXIMAGE_INFO *pSrcInfo );

		//D3DX֐̒` : D3DXCreateTextureFromFileInMemoryEx
		typedef HRESULT ( WINAPI *D3DXCreateTextureFromFileInMemoryExFunc )( LPDIRECT3DDEVICE9 pDevice,
			LPCVOID pSrcData,
			UINT SrcDataSize,
			UINT Width,
			UINT Height,
			UINT MipLevels,
			DWORD Usage,
			D3DFORMAT Format,
			D3DPOOL Pool,
			DWORD Filter,
			DWORD MipFilter,
			D3DCOLOR ColorKey,
			D3DXIMAGE_INFO *pSrcInfo,
			PALETTEENTRY *pPalette,
			LPDIRECT3DTEXTURE9 *ppTexture );

		//D3DX֐̒` : D3DXCreateCubeTextureFromFileInMemoryEx
		typedef HRESULT ( WINAPI *D3DXCreateCubeTextureFromFileInMemoryExFunc )( LPDIRECT3DDEVICE9 pDevice,
			LPCVOID pSrcData,
			UINT SrcDataSize,
			UINT Size,
			UINT MipLevels,
			DWORD Usage,
			D3DFORMAT Format,
			D3DPOOL Pool,
			DWORD Filter,
			DWORD MipFilter,
			D3DCOLOR ColorKey,
			D3DXIMAGE_INFO* pSrcInfo,
			PALETTEENTRY* pPalette,
			LPDIRECT3DCUBETEXTURE9* ppCubeTexture );

		//D3DX֐̒` : D3DXCompileShader
		typedef HRESULT ( WINAPI *D3DXCompileShaderFunc )( LPCSTR pSrcData,
			UINT SrcDataLen,
			CONST D3DXMACRO* pDefines,
			LPD3DXINCLUDE pInclude,
			LPCSTR pFunctionName,
			LPCSTR pProfile,
			DWORD Flags,
			LPD3DXBUFFER* ppShader,
			LPD3DXBUFFER* ppErrorMsgs,
			LPD3DXCONSTANTTABLE* ppConstantTable );

		//D3DX֐̒` : D3DXGetVertexShaderProfile
		typedef LPCSTR ( WINAPI *D3DXGetVertexShaderProfileFunc )( LPDIRECT3DDEVICE9 pDevice );

		//D3DX֐̒` : D3DXGetPixelShaderProfile
		typedef LPCSTR ( WINAPI *D3DXGetPixelShaderProfileFunc )( LPDIRECT3DDEVICE9 pDevice );

		//D3DX֐̒` : D3DXSaveSurfaceToFileW
		typedef HRESULT ( WINAPI *D3DXSaveSurfaceToFileWFunc )( LPCWSTR pDestFile,
			D3DXIMAGE_FILEFORMAT DestFormat,
			LPDIRECT3DSURFACE9 pSrcSurface,
			CONST PALETTEENTRY* pSrcPalette,
			CONST RECT* pSrcRect );

		//D3DX֐̒` : D3DXSaveTextureToFileW
		typedef HRESULT ( WINAPI *D3DXSaveTextureToFileWFunc )( LPCWSTR pDestFile,
			D3DXIMAGE_FILEFORMAT DestFormat,
			LPDIRECT3DBASETEXTURE9 pSrcTexture,
			CONST PALETTEENTRY*       pSrcPalette );

	private:
		Mix::Module m_D3D9Module;
		Mix::Module	m_D3DX9Module;

		IDirect3D9* m_pD3D;
		IDirect3DDevice9* m_pD3DDevice;
		IDirect3DSurface9* m_pD3DBackBuffer;
		D3DCAPS9 m_Caps;
		D3DVIEWPORT9 m_Viewport;
		Mix::Rectangle m_ViewportRect;
		Mix::Rectangle m_ScissorRect;

		Mix::Graphics::RASTERIZER_DESC m_RasterizeDesc;
		Mix::Graphics::DEPTH_DESC m_DepthDesc;
		Mix::Graphics::BLEND_DESC m_BlendDesc;

		Mix::StringA m_VertexShaderProfile;
		Mix::StringA m_PixelShaderProfile;

		DisplayModeList m_DisplayModeList;
		DeviceComboList	m_DeviceComboList;

		STATUS m_Status;

		DEVICEPARAM	m_DeviceParam;

		TARGETSTATE m_TargetState;
		SAMPLERSTATE m_SamplerStateTable[Mix::Graphics::TEXTURESTAGE_MAX][SAMPLERSTATETYPE_MAX];
		RENDERSTATE	m_RenderStateTable[RENDERSTATETYPE_MAX];
		DRAWSTATE m_DrawState;

		UInt32 m_DrawPrimitiveCount;

	public:
		static Device* CreateInstance( Boolean bWaitVSync );

	private:
		Device( Boolean bWaitVSync );
		virtual ~Device( void );

		Boolean EnumDisplay( Mix::UserFile* pSysReport );

		Boolean CreatePresentation( Boolean bWindowed );
		void ChangePresentation( Boolean bWindowed );
		void ResetPresentation( void );
		void TracePresentation( const wchar_t* title );

		void ResetTargetState( void );
		void FlushTargetState( void );

		void ResetRenderState( void );
		void ResetRenderState( RENDERSTATETYPE type );
		void SetRenderState( RENDERSTATETYPE type, UInt32 value );

		void ResetSamplerState( void );
		void SetSamplerState( UInt32 slot, SAMPLERSTATETYPE type, UInt32 value );

		void ResetDrawState( void );
		void FlushDrawState( void );

		UInt32 ComputePrimitiveCount( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 num );

		void AdjustTexturePow2( UInt32& width, UInt32& height );
		void AdjustTextureSquare( UInt32& width, UInt32& height );

	public:
		HRESULT CreateVertexBuffer( UInt32 count, UInt32 stride, Boolean bDynamic, IDirect3DVertexBuffer9** ppVertexBuffer );
		HRESULT CreateIndexBuffer( D3DFORMAT format, UInt32 count, Boolean bDynamic, IDirect3DIndexBuffer9** ppIndexBuffer );
		HRESULT CreateTexture2D( const void* pBuffer, UInt32 size, D3DSURFACE_DESC& desc, IDirect3DTexture9** ppTexture );
		HRESULT CreateCubeTexture( UInt32 edgeLength, D3DFORMAT format, IDirect3DCubeTexture9** ppTexture );
		HRESULT CreateDynamicTexture( UInt32& width, UInt32& height, D3DFORMAT format, IDirect3DTexture9** ppTexture );
		HRESULT CreateTargetTexture( UInt32& width, UInt32& height, D3DFORMAT format, IDirect3DTexture9** ppTexture );
		HRESULT CreateDepthTexture( UInt32 width, UInt32 height, D3DFORMAT format, ::IDirect3DSurface9** ppSurface );
		HRESULT CreateQuery( Mix::Graphics::QUERY_TYPE type, IDirect3DQuery9** ppQuery );

		Mix::Graphics::ITexture* CreateTexture( const void* pBuffer, UInt32 size, const wchar_t* pName, const wchar_t* pNameLabel, D3DSURFACE_DESC& desc );

		static Mix::Graphics::FORMAT ConvertTextureFormat( D3DFORMAT d3dFormat );
		const wchar_t* GetD3DFormatText( D3DFORMAT format );
		const wchar_t* GetD3DResultText( HRESULT result );
		const wchar_t* GetQueryText( Mix::Graphics::QUERY_TYPE type );

	protected:
		virtual void OnDispose( void );

	public:
		virtual Boolean Initialize( Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Mix::UserFile* pSysReport );
		virtual Boolean Update( void );
		virtual Boolean MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

		virtual Boolean CompileShader(	const void* pSrc, UInt32 srcSize,
										Mix::Graphics::SHADER_MACRO* pMacros,
										const char* pFuncName,
										Mix::Graphics::SHADER_TARGET target,
										Mix::Memory::IBuffer** ppBuffer );

	public:
		virtual Boolean CreateVertexLayout( const Mix::Graphics::VERTEX_ELEMENT* pElements, UInt32 numElement, const Mix::Graphics::IVertexShader* pVertexShader, Mix::Graphics::IVertexLayout** ppVertexLayout, const wchar_t* pName );

		virtual Boolean CreateHullShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IHullShader** ppHullShader );
		virtual Boolean CreateHullShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IHullShader** ppHullShader, const wchar_t* pName );
		virtual Boolean CreateDomainShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IDomainShader** ppDomainShader );
		virtual Boolean CreateDomainShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IDomainShader** ppDomainShader, const wchar_t* pName );
		virtual Boolean CreateGeometryShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IGeometryShader** ppGeometryShader );
		virtual Boolean CreateGeometryShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IGeometryShader** ppGeometryShader, const wchar_t* pName );
		virtual Boolean CreateVertexShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IVertexShader** ppVertexShader );
		virtual Boolean CreateVertexShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IVertexShader** ppVertexShader, const wchar_t* pName );
		virtual Boolean CreatePixelShaderFromFile( const wchar_t* pFileName, Mix::Graphics::IPixelShader** ppPixelShader );
		virtual Boolean CreatePixelShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IPixelShader** ppPixelShader, const wchar_t* pName );

		virtual Boolean CreateShaderConstant( UInt32 size, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IShaderConstant** ppShaderConstant, const wchar_t* pName = NULL );

		virtual Boolean CreateVertexBuffer( UInt32 count, UInt32 stride, UInt32 resizeStep, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IVertexBuffer** ppVertexBuffer, const wchar_t* pName );
		virtual Boolean CreateIndexBuffer( Mix::Graphics::INDEX_TYPE type, UInt32 count, UInt32 resizeStep, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IIndexBuffer** ppIndexBuffer, const wchar_t* pName );

		virtual Boolean CreateTextureFromFile( const wchar_t* pFileName, Mix::Graphics::ITexture** ppTexture );
		virtual Boolean CreateTextureFromMemory( const wchar_t* pName, const void* pSrc, UInt32 srcSize, Mix::Graphics::ITexture** ppTexture );
		virtual Boolean CreateCubeTexture( UInt32 edgeLength, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName );
		virtual Boolean CreateDynamicTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName );
		virtual Boolean CreateTargetTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName );
		virtual Boolean CreateDepthTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pName );

		virtual Boolean CreateQuery( Mix::Graphics::QUERY_TYPE type, Mix::Graphics::IQuery** ppQuery );

		virtual Boolean CheckTextureFormat( Mix::Graphics::FORMAT format );
		virtual Boolean CheckCubeTextureFormat( Mix::Graphics::FORMAT format );
		virtual Boolean CheckDynamicTextureFormat( Mix::Graphics::FORMAT format );
		virtual Boolean CheckTargetTextureFormat( Mix::Graphics::FORMAT format );
		virtual Boolean CheckDepthTextureFormat( Mix::Graphics::FORMAT format );
		virtual Boolean CheckIndexType( Mix::Graphics::INDEX_TYPE type );

		virtual void ChangeWindowMode( Boolean bWindowed );
		virtual Boolean GetWindowMode( void ) const;

		virtual Boolean Begin( void );
		virtual void End( void );
		virtual void Present( void );

		virtual void SetTarget( Mix::Graphics::ITexture* pT0, Mix::Graphics::ITexture* pT1, Mix::Graphics::ITexture* pT2, Mix::Graphics::ITexture* pT3, Mix::Graphics::ITexture* pDS );
		virtual void GetTarget( Mix::Graphics::ITexture** ppT0, Mix::Graphics::ITexture** ppT1, Mix::Graphics::ITexture** ppT2, Mix::Graphics::ITexture** ppT3, Mix::Graphics::ITexture** ppDS );

		virtual void SetViewport( Int32 x, Int32 y, Int32 width, Int32 height );
		virtual void SetViewport( const Mix::Rectangle& rect );
		virtual const Mix::Rectangle& GetViewport( void ) const;

		virtual Mix::Matrix4x4 GetScreenTransformMatrix( void ) const;

		virtual void SetScissor( Int32 x, Int32 y, Int32 width, Int32 height );
		virtual void SetScissor( const Mix::Rectangle& rect );
		virtual const Mix::Rectangle& GetScissor( void ) const;

		virtual void Clear( Boolean clearTarget, Boolean clearDepth, const Mix::Vector4& color, Float32 z );

		virtual void SetRasterizerState( Mix::Graphics::FILL_TYPE fillMode, Mix::Graphics::CULL_TYPE cullMode, Boolean bScissoring, Boolean bMultisample );
		virtual void SetRasterizerState( const Mix::Graphics::RASTERIZER_DESC& state );
		virtual const Mix::Graphics::RASTERIZER_DESC& GetRasterizerState( void ) const;

		virtual void SetDepthState( Boolean bTest, Boolean bWrite, Mix::Graphics::ZFUNC_TYPE func );
		virtual void SetDepthState( const Mix::Graphics::DEPTH_DESC& state );
		virtual const Mix::Graphics::DEPTH_DESC& GetDepthState( void ) const;

		virtual void SetBlendState( Mix::Graphics::BLEND_TYPE type, Mix::Graphics::COLOR_WRITE_MASK colorWriteMask );
		virtual void SetBlendState( const Mix::Graphics::BLEND_DESC& desc );
		virtual const Mix::Graphics::BLEND_DESC& GetBlendState( void ) const;

		virtual void SetVertexLayout( Mix::Graphics::IVertexLayout* pVertexLayout );

		virtual void SetHullShader( Mix::Graphics::IHullShader* pHullShader );
		virtual void SetDomainShader( Mix::Graphics::IDomainShader* pDomainShader );
		virtual void SetGeometryShader( Mix::Graphics::IGeometryShader* pGeometryShader );
		virtual void SetVertexShader( Mix::Graphics::IVertexShader* pVertexShader );
		virtual void SetPixelShader( Mix::Graphics::IPixelShader* pPixelShader );

		virtual void SetVertexShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count );
		virtual void SetVertexShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count );
		virtual void SetPixelShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count );
		virtual void SetPixelShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count );

		virtual void SetHullShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetDomainShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetGeometryShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetVertexShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetPixelShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );

		virtual void SetVertexBuffer( Mix::Graphics::IVertexBuffer* pVertexBuffer );
		virtual void SetIndexBuffer( Mix::Graphics::IIndexBuffer* pIndexBuffer );

		virtual UInt32 GetTextureStageMax( void ) const;
		virtual void SetTexture( UInt32 stage, Mix::Graphics::TEXTURE_FILTER_TYPE filter, Mix::Graphics::TEXTURE_ADDRESS_TYPE address, Mix::Graphics::ITexture* pTexture );
		virtual void ResetTexture( UInt32 stage );

		virtual void Draw( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex );
		virtual void DrawIndexed( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex, UInt32 startIndex, UInt32 numIndex );

		virtual Boolean SaveScreenshot( const wchar_t* pFileName );
		virtual Boolean SaveTexture( Mix::Graphics::ITexture* pTexture, const wchar_t* pFileName );

		virtual const Mix::Point& GetScreenSize( void ) const;
		virtual UInt32 GetDrawPrimitiveCount( void ) const;
		virtual Mix::Graphics::SHADER_MODEL GetShaderModel( void ) const;

	private:
		static const wchar_t* FAILED_INITIALIZE;
		static const wchar_t* FAILED_COMPILEVERTEXSHADER;
		static const wchar_t* FAILED_COMPILEPIXELSHADER;
		static const wchar_t* FAILED_CREATEVERTEXLAYOUT;
		static const wchar_t* FAILED_CREATEVERTEXSHADER;
		static const wchar_t* FAILED_CREATEPIXELSHADER;
		static const wchar_t* FAILED_CREATEVERTEXBUFFER;
		static const wchar_t* FAILED_CREATEINDEXBUFFER;
		static const wchar_t* FAILED_CREATETEXTURE;
		static const wchar_t* FAILED_CREATECUBETEXTURE;
		static const wchar_t* FAILED_CREATEDYNAMICTEXTURE;
		static const wchar_t* FAILED_CREATETARGETTEXTURE;
		static const wchar_t* FAILED_CREATEDEPTHTEXTURE;
		static const wchar_t* FAILED_CREATEQUERY;
		static const wchar_t* FAILED_DRAW;
		static const wchar_t* FAILED_DRAWINDEXED;
		static const wchar_t* FAILED_SAVESCREENSHOT;
		static const wchar_t* FAILED_SAVETEXTURE;
	};

}}}
