#include "Mix/Class/Graphics/DX11/VertexShader.h"
#include "Mix/Class/Graphics/DX11/Device.h"
#include "Mix/Memory/IBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX11{

VertexShader* VertexShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature, const wchar_t* pName )
{
	return new VertexShader( pDevice, pVertexShader, pInputSignature, pName );
}

VertexShader::VertexShader( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_VERTEXSHADER, False, pName ),
m_pVertexShader( pVertexShader ),
m_pInputSignature( pInputSignature )
{
}

VertexShader::~VertexShader( void )
{
	MIX_RELEASE( m_pInputSignature );
	MIX_RELEASE( m_pVertexShader );
}

ID3D11VertexShader* VertexShader::GetInterface( void )
{
	return m_pVertexShader;
}

const void* VertexShader::GetInputSignature( void ) const
{
	return m_pInputSignature->GetConstPointer();
}

size_t VertexShader::GetInputSignatureSize( void ) const
{
	return m_pInputSignature->GetSize();
}

}}}
