#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Class/Graphics/DX11/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class TextureTarget : public Mix::Graphics::DX11::Texture, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static TextureTarget* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView,
												const wchar_t* pName );

	private:
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		ID3D11Texture2D* m_pTexture;
		ID3D11RenderTargetView* m_pRTView;
		ID3D11ShaderResourceView* m_pSRView;

	private:
		TextureTarget(	Mix::Graphics::DX11::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView,
						const wchar_t* pName );

		virtual ~TextureTarget( void );

	public:
		ID3D11RenderTargetView* GetRTView( void );

	public:
		virtual ID3D11Resource* GetInterface( void );
		virtual ID3D11ShaderResourceView* GetSRView( void );

		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo );
		virtual void Unlock( void );
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual TEXTURE_TYPE GetType( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual Boolean IsAvailable( void ) const;
	};

}}}
