#include "Mix/Class/Graphics/DX11/TextureTarget.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

TextureTarget* TextureTarget::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView,
												const wchar_t* pName )
{
	return new TextureTarget( pDevice, width, height, format, pTexture, pRTView, pSRView, pName );
}

TextureTarget::TextureTarget(	Mix::Graphics::DX11::Device* pDevice,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView,
								const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_TARGET, False, pName ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pRTView( pRTView ),
m_pSRView( pSRView )
{
	MIX_ASSERT( pTexture != NULL );
	MIX_ASSERT( pRTView != NULL );
	MIX_ASSERT( pSRView != NULL );
}

TextureTarget::~TextureTarget( void )
{
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pRTView );
	MIX_RELEASE( m_pTexture );
}

ID3D11RenderTargetView* TextureTarget::GetRTView( void )
{
	return m_pRTView;
}

ID3D11Resource* TextureTarget::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureTarget::GetSRView( void )
{
	return m_pSRView;
}

Boolean TextureTarget::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureTarget::Unlock( void )
{
}

UInt32 TextureTarget::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureTarget::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::TEXTURE_TYPE TextureTarget::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_TARGET;
}

Mix::Graphics::FORMAT TextureTarget::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureTarget::IsAvailable( void ) const
{
	return ( ( m_pTexture != NULL ) && ( m_pRTView != NULL ) && ( m_pSRView != NULL ) );
}

}}}
