#include "Mix/Class/Graphics/DX11/TextureDepth.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

TextureDepth* TextureDepth::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView,
											const wchar_t* pName )
{
	return new TextureDepth( pDevice, width, height, format, pTexture, pDSView, pName );
}

TextureDepth::TextureDepth(	Mix::Graphics::DX11::Device* pDevice,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView,
							const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_DS, False, pName ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pDSView( pDSView )
{
	MIX_ASSERT( pTexture != NULL );
	MIX_ASSERT( pDSView != NULL );
}

TextureDepth::~TextureDepth( void )
{
	MIX_RELEASE( m_pDSView );
	MIX_RELEASE( m_pTexture );
}

ID3D11DepthStencilView* TextureDepth::GetDSView( void )
{
	return m_pDSView;
}

ID3D11Resource* TextureDepth::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureDepth::GetSRView( void )
{
	return NULL;
}

Boolean TextureDepth::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureDepth::Unlock( void )
{
}

UInt32 TextureDepth::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureDepth::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::TEXTURE_TYPE TextureDepth::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_DEPTH;
}

Mix::Graphics::FORMAT TextureDepth::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureDepth::IsAvailable( void ) const
{
	return ( ( m_pTexture != NULL ) && ( m_pDSView != NULL ) );
}

}}}
