#include "Mix/Class/Graphics/DX11/TextureCube.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

TextureCube* TextureCube::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView, ID3D11RenderTargetView* pRTView,
											Boolean bRegistMap, const wchar_t* pName )
{
	return new TextureCube( pDevice, width, height, format, pTexture, pSRView, pRTView, bRegistMap, pName );
}

TextureCube::TextureCube(	Mix::Graphics::DX11::Device* pDevice,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView, ID3D11RenderTargetView* pRTView,
							Boolean bRegistMap, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_TEXTURE_CUBE, bRegistMap, pName ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pSRView( pSRView ),
m_pRTView( pRTView )
{
}

TextureCube::~TextureCube( void )
{
	MIX_RELEASE( m_pRTView );
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pTexture );
}

ID3D11RenderTargetView* TextureCube::GetRTView( void )
{
	return m_pRTView;
}

ID3D11Resource* TextureCube::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureCube::GetSRView( void )
{
	return m_pSRView;
}

Boolean TextureCube::Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo )
{
	return False;
}

void TextureCube::Unlock( void )
{
}

UInt32 TextureCube::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureCube::GetHeight( void ) const
{
	return m_Height;
}

TEXTURE_TYPE TextureCube::GetType( void ) const
{
	return Mix::Graphics::TEXTURE_CUBE;
}

Mix::Graphics::FORMAT TextureCube::GetFormat( void ) const
{
	return m_Format;
}

Boolean TextureCube::IsAvailable( void ) const
{
	return True;
}

}}}
