#pragma once

#include "Mix/Class/Graphics/DX11/Texture.h"
#include "Mix/Class/Graphics/Common/DeviceObject.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class Texture2D : public Mix::Graphics::DX11::Texture, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static Texture2D* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView,
											Boolean bRegisterMap, const wchar_t* pName );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;
		Boolean m_bDynamic;
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		ID3D11Texture2D* m_pTexture;
		ID3D11ShaderResourceView* m_pSRView;
		Boolean m_bLock;

	private:
		Texture2D(	Mix::Graphics::DX11::Device* pDevice,
					Boolean bDynamic, UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
					ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView,
					Boolean bRegisterMap, const wchar_t* pName );

		virtual ~Texture2D( void );

	public:
		void Attach( ID3D11Texture2D* pD3DTexture2D, ID3D11ShaderResourceView* pShaderResourceView );

	public:
		virtual ID3D11Resource* GetInterface( void );
		virtual ID3D11ShaderResourceView* GetSRView( void );

		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo );
		virtual void Unlock( void );
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual TEXTURE_TYPE GetType( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual Boolean IsAvailable( void ) const;
	};

}}}
