#include "Mix/Class/Graphics/DX11/Query.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

Query* Query::CreateInstance( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_TYPE type, ID3D11Query* pD3DQuery, const wchar_t* pName )
{
	return new Query( pDevice, type, pD3DQuery, pName );
}

Query::Query( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_TYPE type, ID3D11Query* pD3DQuery, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_QUERY, False, pName ),
m_pDevice( pDevice ),
m_Type( type ),
m_pD3DQuery( pD3DQuery )
{
	MIX_ADD_REF( m_pDevice );
}

Query::~Query( void )
{
	MIX_RELEASE( m_pD3DQuery );
	MIX_RELEASE( m_pDevice );
}

void Query::Begin( void )
{
	m_pDevice->BeginQuery( m_pD3DQuery );
}

void Query::End( void )
{
	m_pDevice->EndQuery( m_pD3DQuery );
}

Boolean Query::GetData( UInt32& data, Boolean bFlush ) const
{
	HRESULT ret;

	ret = m_pDevice->GetQueryData( m_pD3DQuery, bFlush, data );
	if( ret != S_OK )
	{
		return False;
	}

	return True;
}

Mix::Graphics::QUERY_TYPE Query::GetType( void ) const
{
	return m_Type;
}

}}}
