#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IPixelShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class PixelShader : public Mix::Graphics::IPixelShader, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static PixelShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader, const wchar_t* pName );

	private:
		ID3D11PixelShader* m_pPixelShader;

	private:
		PixelShader( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader, const wchar_t* pName );
		virtual ~PixelShader( void );

	public:
		ID3D11PixelShader* GetInterface( void );
	};

}}}
