#include "Mix/Class/Graphics/DX11/PixelShader.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

PixelShader* PixelShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader, const wchar_t* pName )
{
	return new PixelShader( pDevice, pPixelShader, pName );
}

PixelShader::PixelShader( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_PIXELSHADER, False, pName ),
m_pPixelShader( pPixelShader )
{
}

PixelShader::~PixelShader( void )
{
	MIX_RELEASE( m_pPixelShader );
}

ID3D11PixelShader* PixelShader::GetInterface( void )
{
	return m_pPixelShader;
}

}}}
