#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IIndexBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class IndexBuffer : public Mix::Graphics::IIndexBuffer, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static IndexBuffer* CreateInstance( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::INDEX_TYPE type, UInt32 count, UInt32 resizeStep, Boolean bDynamic, const wchar_t* pName );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;

		ID3D11Buffer* m_pIndexBuffer;
		D3D11_MAPPED_SUBRESOURCE m_Mapped;

		Mix::Graphics::INDEX_TYPE m_Type;

		UInt32 m_Stride;
		UInt32 m_ResizeStep;
		Boolean m_bDynamic;

		Boolean m_bLock;
		Boolean m_bResize;

		UInt8* m_pBuffer;

		UInt8* m_pSource;

		UInt32 m_Count;
		UInt32 m_Capacity;

	private:
		IndexBuffer( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::INDEX_TYPE type, UInt32 count, UInt32 resizeStep, Boolean bDynamic, const wchar_t* pName );
		virtual ~IndexBuffer( void );

	public:
		HRESULT Initialize( const void* pInitialData );
		ID3D11Buffer* GetInterface( void );

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );

		virtual Boolean Push( const void* pData, UInt32 count );
		virtual void* Push( UInt32 count );

		virtual void Clear( void );

		virtual Mix::Graphics::INDEX_TYPE GetType( void ) const;

		virtual UInt32 GetCount( void ) const;
		virtual UInt32 GetCapacity( void ) const;
	};

}}}
