#include "Mix/Class/Graphics/DX11/HullShader.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

HullShader* HullShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader, const wchar_t* pName )
{
	return new HullShader( pDevice, pHullShader, pName );
}

HullShader::HullShader( Mix::Graphics::DX11::Device* pDevice, ID3D11HullShader* pHullShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_HULLSHADER, False, pName ),
m_pHullShader( pHullShader )
{
}

HullShader::~HullShader( void )
{
	MIX_RELEASE( m_pHullShader );
}

ID3D11HullShader* HullShader::GetInterface( void )
{
	return m_pHullShader;
}

}}}
