#pragma once

#include "Mix/Class/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IGeometryShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class GeometryShader : public Mix::Graphics::IGeometryShader, public Mix::Graphics::Common::DeviceObject
	{
	public:
		static GeometryShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader, const wchar_t* pName );

	private:
		ID3D11GeometryShader* m_pGeometryShader;

	private:
		GeometryShader( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader, const wchar_t* pName );
		virtual ~GeometryShader( void );

	public:
		ID3D11GeometryShader* GetInterface( void );
	};

}}}
