#include "Mix/Class/Graphics/DX11/GeometryShader.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

GeometryShader* GeometryShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader, const wchar_t* pName )
{
	return new GeometryShader( pDevice, pGeometryShader, pName );
}

GeometryShader::GeometryShader( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_GEOMETRYSHADER, False, pName ),
m_pGeometryShader( pGeometryShader )
{
}

GeometryShader::~GeometryShader( void )
{
	MIX_RELEASE( m_pGeometryShader );
}

ID3D11GeometryShader* GeometryShader::GetInterface( void )
{
	return m_pGeometryShader;
}

}}}
