#include "Mix/Class/Graphics/DX11/DomainShader.h"
#include "Mix/Class/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

DomainShader* DomainShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader, const wchar_t* pName )
{
	return new DomainShader( pDevice, pDomainShader, pName );
}

DomainShader::DomainShader( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader, const wchar_t* pName ) :
DeviceObject( pDevice, Mix::Graphics::Common::DOT_DOMAINSHADER, False, pName ),
m_pDomainShader( pDomainShader )
{
}

DomainShader::~DomainShader( void )
{
	MIX_RELEASE( m_pDomainShader );
}

ID3D11DomainShader* DomainShader::GetInterface( void )
{
	return m_pDomainShader;
}

}}}
